/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.screen;

import com.jab125.mpuc.client.gui.screen.TemplateScreen;
import com.jab125.mpuc.client.gui.widget.ScrollableHotfixWidget;
import com.jab125.mpuc.util.HotfixApplier;
import com.jab125.mpuc.util.HotfixEventHandler;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class HotfixScreen
extends TemplateScreen {
    private final Screen parent;
    private ScrollableHotfixWidget rrr;
    private Component downloadingText = null;

    public HotfixScreen(Screen screen) {
        super((Component)Component.empty());
        this.parent = screen;
    }

    protected void init() {
        this.rrr = new ScrollableHotfixWidget(this.minecraft, this.width, this.height, 32, this.height - 54, null);
        this.addRenderableWidget((GuiEventListener)this.rrr);
        this.addButtonWidget(this.createButton(this.width / 2 - 100, this.height - 25, 98, 20, CommonComponents.GUI_DONE, button -> this.minecraft.setScreen(this.parent)));
        MutableComponent text = Component.translatable((String)"screen.modpack-update-checker.hotfix.apply-hotfix");
        this.addButtonWidget(this.createButton(this.width / 2 + 2, this.height - 25, 98, 20, (Component)text, button -> this.applyHotfixes()));
        text = Component.translatable((String)"screen.modpack-update-checker.hotfix.deselect-all");
        this.addButtonWidget(this.createButton(this.width / 2 - 100, this.height - 50, 98, 20, (Component)text, button -> this.rrr.children().forEach(a -> a.setSelected(false))));
        text = Component.translatable((String)"screen.modpack-update-checker.hotfix.select-all");
        this.addButtonWidget(this.createButton(this.width / 2 + 2, this.height - 50, 98, 20, (Component)text, button -> this.rrr.children().forEach(a -> a.setSelected(true))));
    }

    private boolean applyHotfixes() {
        ArrayList apply = this.rrr.children().stream().filter(ScrollableHotfixWidget.TextEntry::isSelected).collect(Collector.of(ArrayList::new, (a, b) -> a.add(b.getFileName()), (a, b) -> a, new Collector.Characteristics[0]));
        if (apply.size() == 0) {
            return true;
        }
        return HotfixApplier.applyHotfixes(apply, new HotfixEventHandler(){

            @Override
            public void beforeDownload(int alreadyDownloaded, int totalFileAmount, String fileName, int progressPercentage) {
                HotfixScreen.this.downloadingText = Component.translatable((String)"screen.modpack-update-checker.hotfix.downloading-text", (Object[])new Object[]{alreadyDownloaded, totalFileAmount, fileName, progressPercentage});
            }

            @Override
            public void afterDownload() {
                HotfixScreen.this.downloadingText = null;
                HotfixScreen.this.rrr.children().removeIf(ScrollableHotfixWidget.TextEntry::isSelected);
            }

            @Override
            public void onError() {
                HotfixScreen.this.downloadingText = null;
            }

            @Override
            public void afterHotfixInit() {
                Minecraft.getInstance().execute(() -> Minecraft.getInstance().getToasts().addToast((Toast)new SystemToast(SystemToast.SystemToastId.PACK_COPY_FAILURE, (Component)Component.translatable((String)"screen.modpack-update-checker.hotfix.hotfix-applied"), (Component)Component.translatable((String)"screen.modpack-update-checker.hotfix.hotfix-applied.description"))));
            }
        });
    }

    public void render(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        super.render(matrices, mouseX, mouseY, delta);
        matrices.drawCenteredString(this.font, (Component)(this.downloadingText != null ? this.downloadingText : Component.translatable((String)"screen.modpack-update-checker.hotfix.title")), this.width / 2, 5, -1);
        if (HotfixApplier.isDownloading()) {
            Component component = this.processEstimatedTime();
            int n = this.width / 2;
            Objects.requireNonNull(this.font);
            matrices.drawCenteredString(this.font, component, n, 5 + 9, -1);
            HotfixScreen.i_fill(matrices, 0, this.height - 54, this.width, this.height - 50, -16777216);
            HotfixScreen.i_fill(matrices, 0, this.height - 54, (int)((double)this.width * HotfixApplier.getProgress()), this.height - 50, -1);
        }
        if (HotfixApplier.isDownloading()) {
            HotfixScreen.i_fill(matrices, 0, 0, this.width, this.height, 0x77000000);
            MutableComponent mutableComponent = Component.translatable((String)"screen.modpack-update-checker.hotfix.no-leaving");
            int n = this.width / 2;
            int n2 = this.height / 2;
            Objects.requireNonNull(this.font);
            matrices.drawCenteredString(this.font, (Component)mutableComponent, n, n2 - 9 / 2, -1);
        }
    }

    public static void i_fill(GuiGraphics matrices, int x1, int y1, int x2, int y2, int color) {
        matrices.fill(x1, y1, x2, y2, color);
    }

    private Component processEstimatedTime() {
        long estimatedTimeRemaining = HotfixApplier.getEstimatedTimeRemaining();
        String seconds = String.valueOf((int)(estimatedTimeRemaining % 60L));
        String minutes = String.valueOf((int)((float)estimatedTimeRemaining / 60.0f % 60.0f));
        String hours = String.valueOf((int)((float)estimatedTimeRemaining / 60.0f / 60.0f % 60.0f));
        Object secondsF = seconds.length() == 1 ? "0" + seconds : seconds;
        Object minutesF = minutes.length() == 1 ? "0" + minutes : minutes;
        Object hoursF = hours.length() == 1 ? "0" + hours : hours;
        return Component.translatable((String)"screen.modpack-update-checker.hotfix.estimated-time", (Object[])new Object[]{hoursF, minutesF, secondsF, hours, minutes, seconds});
    }

    public void resize(Minecraft client, int width, int height) {
        if (HotfixApplier.isDownloading()) {
            return;
        }
        super.resize(client, width, height);
    }

    public void onClose() {
        if (HotfixApplier.isDownloading()) {
            return;
        }
        this.minecraft.setScreen(this.parent);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (HotfixApplier.isDownloading()) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (HotfixApplier.isDownloading()) {
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (HotfixApplier.isDownloading()) {
            return false;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }
}

