/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.screen;

import com.jab125.mpuc.Hotfixes;
import com.jab125.mpuc.client.gui.screen.DebugScreen;
import com.jab125.mpuc.client.gui.screen.TemplateScreen;
import com.jab125.mpuc.client.gui.widget.ScrollableGenericTextWidget;
import com.jab125.mpuc.client.util.DebugInfo;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.config.MpucConfig;
import com.mojang.blaze3d.Blaze3D;
import java.io.IOException;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class EditorScreen
extends TemplateScreen {
    private final Screen parent;
    private ScrollableGenericTextWidget textWidget;
    private String text;

    public EditorScreen(Screen parent) {
        super((Component)Component.empty());
        this.parent = parent;
        this.text = this.getText();
    }

    protected void init() {
        super.init();
        this.textWidget = new ScrollableGenericTextWidget(this.minecraft, this.width, this.height, 128, this.height - 32, this.text);
        this.addRenderableWidget((GuiEventListener)this.textWidget);
        MutableComponent text = Component.translatable((String)"screen.modpack-update-checker.modpack-update.title");
        this.addButtonWidget(this.createButton(15, 15, 150, 20, (Component)Component.translatable((String)"screen.modpack-update-checker.editor.migrate-config"), button -> {
            MpucConfig modpackUpdateCheckerConfig = ConfigInstances.getModpackUpdateCheckerConfig();
            boolean migrated = false;
            boolean errored = false;
            try {
                migrated = modpackUpdateCheckerConfig.tryMigrate();
            }
            catch (IOException e) {
                errored = true;
                e.printStackTrace();
                this.text = this.text + "Failed to migrate config.\n";
            }
            if (!errored) {
                this.text = migrated ? this.text + "Migrated config from v" + DebugInfo.schemaVersion + " to v9\n" : this.text + "Config already on v9!\n";
            }
            this.textWidget.setText(this.text);
        }));
        this.addButtonWidget(this.createButton(15, 37, 150, 20, (Component)Component.translatable((String)"screen.modpack-update-checker.editor.debug"), button -> this.minecraft.setScreen((Screen)new DebugScreen(this))));
        Button button1 = this.createButton(15, 59, 150, 20, (Component)Component.translatable((String)"screen.modpack-update-checker.editor.reload"), button -> {
            ConfigInstances.reload(ConfigInstances.MODPACK_UPDATE_CHECKER_CONFIG);
            this.text = this.text + "Reloaded config.\n";
            this.textWidget.setText(this.text);
        }, b -> Component.translatable((String)"screen.modpack-update-checker.editor.reload.info"));
        this.addButtonWidget(button1);
        Button button2 = this.createButton(15, 81, 150, 20, (Component)Component.translatable((String)"screen.modpack-update-checker.editor.reload-hotfixes"), button -> {
            try {
                Hotfixes.init();
                this.text = this.text + "Reloaded hotfixes.\n";
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                this.text = this.text + "Failed to reload hotfixes.\n";
            }
            this.textWidget.setText(this.text);
        });
        button2.active = Hotfixes.hotfixesEnabled;
        this.addButtonWidget(button2);
        Button button3 = this.createButton(15, 103, 150, 20, (Component)Component.translatable((String)"screen.modpack-update-checker.editor.modpack-piracy"), button -> Blaze3D.youJustLostTheGame(), b -> Component.translatable((String)"screen.modpack-update-checker.editor.modpack-piracy.info"));
        button3.active = false;
        this.addButtonWidget(button3);
        Button button4 = this.createButton(167, 15, 150, 20, (Component)Component.translatable((String)"screen.modpack-update-checker.editor.add-modpack-mods"), button -> {}, b -> Component.translatable((String)"screen.modpack-update-checker.editor.add-modpack-mods.info"));
        button4.active = false;
        this.addButtonWidget(button4);
        this.addButtonWidget(this.createButton(this.width / 2 - 100, this.height - 25, 200, 20, CommonComponents.GUI_DONE, button -> this.minecraft.setScreen(this.parent)));
        this.addCredits();
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        super.render(matrices, mouseX, mouseY, delta);
        matrices.drawCenteredString(this.font, (Component)Component.translatable((String)"screen.modpack-update-checker.editor.title"), this.width / 2, 5, -1);
    }

    private String getText() {
        Object str = "";
        str = (String)str + "Welcome to the editor\n";
        str = (String)str + "This is an internal screen!\n";
        str = (String)str + "If you are seeing this, contact the modpack authors!";
        return (String)str + "\n";
    }
}

