/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.screen;

import com.jab125.mpuc.Hotfixes;
import com.jab125.mpuc.api.MpucApi;
import com.jab125.mpuc.client.gui.screen.TemplateScreen;
import com.jab125.mpuc.client.gui.widget.ScrollableGenericTextWidget;
import com.jab125.mpuc.client.gui.widget.flow.FlowMarkdownUtils;
import com.jab125.mpuc.client.util.DebugInfo;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.config.MpucConfig;
import com.jab125.mpuc.util.Platform;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class DebugScreen
extends TemplateScreen {
    private final Screen parent;

    public DebugScreen(Screen parent) {
        super((Component)Component.empty());
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new ScrollableGenericTextWidget(this.minecraft, this.width, this.height, 32, this.height - 32, this.getText()));
        this.addButtonWidget(this.createButton(this.width / 2 - 100, this.height - 25, 200, 20, CommonComponents.GUI_DONE, button -> this.minecraft.setScreen(this.parent)));
        this.addCredits();
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        super.render(matrices, mouseX, mouseY, delta);
        matrices.drawCenteredString(this.font, (Component)Component.translatable((String)"screen.modpack-update-checker.debug.title"), this.width / 2, 5, -1);
    }

    private String getText() {
        MpucConfig config = ConfigInstances.getModpackUpdateCheckerConfig();
        Object str = "";
        str = (String)str + "Mod Version: " + MpucApi.getInstance().getModVersion() + "\n";
        str = (String)str + "Available Text Renderers: " + String.join((CharSequence)", ", FlowMarkdownUtils.COMPILERS.entrySet().stream().map(a -> (String)a.getKey()).sorted().collect(Collectors.toList())) + "\n";
        str = (String)str + "Legacy4J support: ";
        str = (String)str + (Platform.getModList().stream().map(Platform.Mod::getId).anyMatch("legacy"::equals) ? "active\n\n" : "inactive\n\n");
        str = (String)str + "Hotfix info:\n";
        str = (String)str + "Hotfixes available: " + Hotfixes.hotfixAvailable + "\n";
        str = (String)str + "# of hotfixes available: " + Hotfixes.availableHotfixes.size();
        str = (String)str + "\n\nConfiguration information:\n";
        str = (String)str + "Schema version: v" + DebugInfo.schemaVersion;
        str = (String)str + "\nUpdate Checker Type: " + String.valueOf((Object)config.type) + ", " + MpucConfig.getId((Object)config.type);
        str = (String)str + "\n\nModpack information:\n";
        str = (String)str + "Modpack Name: " + MpucApi.getInstance().getModpackName();
        str = (String)str + "\nCurrent Modpack Version: " + MpucApi.getInstance().getCurrentModpackVersion();
        str = (String)str + "\nLatest Modpack Version: " + MpucApi.getInstance().getLatestModpackVersion();
        str = (String)str + "\nModpack Author: " + config.modpackAuthor;
        str = (String)str + "\nModpack Release Type: " + config.modpackReleaseType;
        str = (String)str + "\nButton X Offset: " + config.buttonXOffset;
        str = (String)str + "\nButton Y Offset: " + config.buttonYOffset;
        return (String)str + "\n";
    }
}

