/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.api;

import com.jab125.mpuc.client.gui.widget.flow.FlowMarkdownUtils;
import com.jab125.mpuc.client.gui.widget.flow.widgets.AbstractWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.TextWidget;
import com.jab125.mpuc.util.ChangelogUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface MarkdownRenderer {
    public static final MarkdownRenderer BASIC = (assumedOutputWidth, maxWidth, maxHeight, text, formatting) -> {
        MutableComponent formatted = (MutableComponent)ChangelogUtils.fromString(text);
        if (formatting != null) {
            formatted.withStyle(formatting);
        }
        return new TextWidget(Minecraft.getInstance(), (FormattedText)formatted, assumedOutputWidth, 0, 1.0, true);
    };

    public AbstractWidget render(int var1, int var2, int var3, String var4, @Nullable ChatFormatting var5);

    default public AbstractWidget render(int assumedOutputWidth, int maxWidth, int maxHeight, String text) {
        return this.render(assumedOutputWidth, maxWidth, maxHeight, text, null);
    }

    default public String getBaseTranslationKey() {
        String[] split;
        String id = (String)FlowMarkdownUtils.COMPILERS.entrySet().stream().filter(a -> a.getValue() == this).findFirst().orElseThrow().getKey();
        StringBuilder n = new StringBuilder("modpack-update-checker.markdown.renderer.");
        for (String s : split = id.split(":")) {
            n.append(s.replace('/', '.'));
            n.append(".");
        }
        n.setLength(n.length() - 1);
        return n.toString();
    }

    default public String getDisplayNameTranslationKey() {
        return this.getBaseTranslationKey() + ".title";
    }

    default public String getDescriptionTranslationKey() {
        return this.getBaseTranslationKey() + ".description";
    }
}

