/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc;

import com.jab125.mpuc.Hotfixes;
import com.jab125.mpuc.api.MpucApi;
import com.jab125.mpuc.client.MpucClient;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.config.MpucConfig;
import com.jab125.mpuc.config.PlatformMods;
import com.jab125.mpuc.recipe.ChangelogBookRecipe;
import com.jab125.mpuc.server.MpucServer;
import com.jab125.mpuc.util.Events;
import com.jab125.mpuc.util.OnlineInfo;
import com.jab125.mpuc.util.Platform;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.util.UUID;
import java.util.function.Supplier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;

@Mod(value="modpackupdatechecker")
public class Mpuc {
    public static IEventBus modEventBus;
    public static final String OBJECT_SHARE_CONFIG;
    public static final Supplier<TypesafeMap.Key<MpucConfig>> OBJECT_SHARE_CONFIG_;
    public static final int MPUC_PROTOCOL_VERSION = 15;
    public static final String RANDOM_UUID;

    public Mpuc(IEventBus bus) {
        modEventBus = bus;
        this.onInitialize();
        Platform.executeDist(Platform.Environment.CLIENT, () -> MpucClient::new);
        Platform.executeDist(Platform.Environment.SERVER, () -> MpucServer::new);
    }

    public void onInitialize() {
        ConfigInstances.setModpackUpdateCheckerConfig(MpucConfig.load());
        ConfigInstances.setPlatformMods(PlatformMods.deserialize());
        System.out.println("[Modpack Update Checker] Loaded configuration file.");
        this.fetchOnlineInfo();
        Events.CONFIG_RELOADED.subscribe(a -> {
            this.fetchOnlineInfo();
            this.putInObjectShare();
            try {
                Hotfixes.init();
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            Hotfixes.init();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.putInObjectShare();
        ChangelogBookRecipe.register();
    }

    private void putInObjectShare() {
        Launcher.INSTANCE.environment().computePropertyIfAbsent(OBJECT_SHARE_CONFIG_.get(), o -> ConfigInstances.getModpackUpdateCheckerConfig());
    }

    private OnlineInfo fetchOnlineInfo() {
        return OnlineInfo.create(ConfigInstances.getModpackUpdateCheckerConfig());
    }

    public static String fetchUrlAsString(String s) throws IOException, InterruptedException {
        if (Platform.isDevelopmentEnvironment() && s.startsWith("local/")) {
            s = s.replaceAll("%20", " ");
            return Files.readString(Platform.getGameDir().resolve(".local").resolve(s.substring("local/".length())));
        }
        String userAgent = "%s/%s".formatted("Modpack-Update-Checker/modpackUpdateChecker", MpucApi.getInstance().getModVersion());
        HttpResponse<String> d = HttpClient.newHttpClient().send(HttpRequest.newBuilder().GET().header("User-Agent", userAgent).uri(URI.create(s)).build(), HttpResponse.BodyHandlers.ofString());
        return d.body();
    }

    static {
        OBJECT_SHARE_CONFIG = "modpack-update-checker:mpuc-config";
        OBJECT_SHARE_CONFIG_ = IEnvironment.buildKey((String)OBJECT_SHARE_CONFIG, MpucConfig.class);
        RANDOM_UUID = UUID.randomUUID().toString();
    }
}

