/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.ai.sensing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;

public class PiglinPrisonerSpecificSensor
extends Sensor<LivingEntity> {
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_NEMESIS, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, (Object[])new MemoryModuleType[]{MemoryModuleType.NEARBY_ADULT_PIGLINS, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, MemoryModuleType.NEAREST_REPELLENT});
    }

    protected void doTick(ServerLevel level, LivingEntity piglinPrisoner) {
        Brain brain = piglinPrisoner.getBrain();
        brain.setMemory(MemoryModuleType.NEAREST_REPELLENT, PiglinPrisonerSpecificSensor.findNearestRepellent(level, piglinPrisoner));
        Optional<Object> optional = Optional.empty();
        Optional<Object> optional3 = Optional.empty();
        Optional<Object> optional4 = Optional.empty();
        Optional<Object> optional5 = Optional.empty();
        Optional<Object> optional6 = Optional.empty();
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        NearestVisibleLivingEntities nearestvisiblelivingentities = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
        for (LivingEntity livingentity : nearestvisiblelivingentities.findAll(entity -> true)) {
            Hoglin hoglin;
            if (livingentity instanceof PiglinBrute) {
                PiglinBrute piglinbrute = (PiglinBrute)livingentity;
                list.add(piglinbrute);
                continue;
            }
            if (livingentity instanceof Piglin) {
                Piglin piglin = (Piglin)livingentity;
                if (piglin.isBaby() && optional3.isEmpty()) {
                    optional3 = Optional.of(piglin);
                    continue;
                }
                if (!piglin.isAdult()) continue;
                list.add(piglin);
                continue;
            }
            if (livingentity instanceof Player) {
                Player player = (Player)livingentity;
                if (optional5.isEmpty()) {
                    optional5 = Optional.of(player);
                }
                if (!optional6.isEmpty() || player.isSpectator() || !PiglinAi.isPlayerHoldingLovedItem((LivingEntity)player)) continue;
                optional6 = Optional.of(player);
                continue;
            }
            if (!(!optional.isPresent() && (livingentity instanceof WitherSkeleton || livingentity instanceof WitherBoss || livingentity instanceof Hoglin && (hoglin = (Hoglin)livingentity).isAdult()))) {
                if (!optional4.isEmpty() || !PiglinAi.isZombified((EntityType)livingentity.getType())) continue;
                optional4 = Optional.of(livingentity);
                continue;
            }
            optional = Optional.of((Mob)livingentity);
        }
        for (LivingEntity livingentity1 : (List)brain.getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).orElse(ImmutableList.of())) {
            AbstractPiglin abstractpiglin;
            if (!(livingentity1 instanceof AbstractPiglin) || !(abstractpiglin = (AbstractPiglin)livingentity1).isAdult()) continue;
            list1.add(abstractpiglin);
        }
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_NEMESIS, optional);
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, optional4);
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER, optional5);
        brain.setMemory(MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, optional6);
        brain.setMemory(MemoryModuleType.NEARBY_ADULT_PIGLINS, (Object)list1);
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, (Object)list);
        brain.setMemory(MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, (Object)list.size());
    }

    private static Optional<BlockPos> findNearestRepellent(ServerLevel level, LivingEntity livingEntity) {
        return BlockPos.findClosestMatch((BlockPos)livingEntity.blockPosition(), (int)8, (int)4, blockPos -> PiglinPrisonerSpecificSensor.isValidRepellent(level, blockPos));
    }

    private static boolean isValidRepellent(ServerLevel serverlevel, BlockPos blockpos) {
        BlockState blockstate = serverlevel.getBlockState(blockpos);
        boolean flag = blockstate.is(BlockTags.PIGLIN_REPELLENTS);
        return flag && blockstate.is(Blocks.SOUL_CAMPFIRE) ? CampfireBlock.isLitCampfire((BlockState)blockstate) : flag;
    }
}

