/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import fuzs.eternalnether.world.entity.monster.piglin.PiglinPrisoner;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class ModStopAdmiringIfTiredOfTryingToReachItem<E extends PiglinPrisoner>
extends Behavior<E> {
    private final int maxTimeToReachItem;
    private final int disableTime;

    public ModStopAdmiringIfTiredOfTryingToReachItem(int maxTimeToReachItem, int disableTime) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ADMIRING_ITEM, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.DISABLE_WALK_TO_ADMIRE_ITEM, (Object)MemoryStatus.REGISTERED));
        this.maxTimeToReachItem = maxTimeToReachItem;
        this.disableTime = disableTime;
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, E piglinPrisoner) {
        return piglinPrisoner.getOffhandItem().isEmpty();
    }

    protected void start(ServerLevel serverLevel, E piglinPrisoner, long gameTime) {
        Brain<PiglinPrisoner> brain = ((PiglinPrisoner)((Object)piglinPrisoner)).getBrain();
        Optional optional = brain.getMemory(MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM);
        if (optional.isEmpty()) {
            brain.setMemory(MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM, (Object)0);
        } else {
            int reachAttemptTime = (Integer)optional.get();
            if (reachAttemptTime > this.maxTimeToReachItem) {
                brain.eraseMemory(MemoryModuleType.ADMIRING_ITEM);
                brain.eraseMemory(MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM);
                brain.setMemoryWithExpiry(MemoryModuleType.DISABLE_WALK_TO_ADMIRE_ITEM, (Object)true, (long)this.disableTime);
            } else {
                brain.setMemory(MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM, (Object)(reachAttemptTime + 1));
            }
        }
    }
}

