/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import fuzs.eternalnether.world.entity.monster.piglin.PiglinPrisoner;
import fuzs.eternalnether.world.entity.monster.piglin.PiglinPrisonerAi;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;

public class ModStartAdmiringItemIfSeen<E extends PiglinPrisoner>
extends Behavior<E> {
    private final int admireDuration;

    public ModStartAdmiringItemIfSeen(int admireDuration) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ADMIRING_ITEM, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.ADMIRING_DISABLED, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.DISABLE_WALK_TO_ADMIRE_ITEM, (Object)MemoryStatus.VALUE_ABSENT));
        this.admireDuration = admireDuration;
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, E piglinPrisoner) {
        ItemEntity itementity = ((PiglinPrisoner)((Object)piglinPrisoner)).getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM).orElse(null);
        return itementity != null && PiglinPrisonerAi.isLovedItem(itementity.getItem());
    }

    protected void start(ServerLevel serverLevel, E piglinPrisoner, long gameTime) {
        ((PiglinPrisoner)((Object)piglinPrisoner)).getBrain().setMemoryWithExpiry(MemoryModuleType.ADMIRING_ITEM, (Object)true, (long)this.admireDuration);
    }
}

