/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.eternalnether.EternalNether;
import fuzs.eternalnether.client.model.WarpedEndermanModel;
import fuzs.eternalnether.client.renderer.entity.layers.ModCarriedBlockLayer;
import fuzs.eternalnether.client.renderer.entity.layers.ModEnderEyesLayer;
import fuzs.eternalnether.world.entity.monster.WarpedEnderMan;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class WarpedEnderManRenderer
extends MobRenderer<WarpedEnderMan, WarpedEndermanModel> {
    private static final Map<WarpedEnderMan.WarpedEnderManVariant, ResourceLocation> TEXTURE_LOCATIONS = Maps.immutableEnumMap((Map)ImmutableMap.of((Object)((Object)WarpedEnderMan.WarpedEnderManVariant.FRESH), (Object)EternalNether.id("textures/entity/enderman/warped_enderman_fresh.png"), (Object)((Object)WarpedEnderMan.WarpedEnderManVariant.SHORT_VINE), (Object)EternalNether.id("textures/entity/enderman/warped_enderman_short_vine.png"), (Object)((Object)WarpedEnderMan.WarpedEnderManVariant.LONG_VINE), (Object)EternalNether.id("textures/entity/enderman/warped_enderman_long_vine.png")));
    private final RandomSource random = RandomSource.create();

    public WarpedEnderManRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new WarpedEndermanModel(WarpedEndermanModel.createBodyLayer().bakeRoot()), 0.5f);
        this.addLayer((RenderLayer)new ModEnderEyesLayer(this));
        this.addLayer(new ModCarriedBlockLayer(this, context.getBlockRenderDispatcher()));
    }

    public void render(WarpedEnderMan warpedEnderMan, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        BlockState blockstate = warpedEnderMan.getCarriedBlock();
        WarpedEndermanModel enderManModel = (WarpedEndermanModel)this.getModel();
        enderManModel.carrying = blockstate != null;
        enderManModel.creepy = warpedEnderMan.isCreepy();
        super.render((LivingEntity)warpedEnderMan, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public Vec3 getRenderOffset(WarpedEnderMan warpedEnderMan, float offset) {
        return warpedEnderMan.isCreepy() ? new Vec3(this.random.nextGaussian() * 0.02, 0.0, this.random.nextGaussian() * 0.02) : super.getRenderOffset((Entity)warpedEnderMan, offset);
    }

    public ResourceLocation getTextureLocation(WarpedEnderMan warpedEnderMan) {
        return TEXTURE_LOCATIONS.get((Object)warpedEnderMan.getVariant());
    }
}

