/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.client.model;

import fuzs.eternalnether.world.entity.monster.WarpedEnderMan;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class WarpedEndermanModel
extends EndermanModel<WarpedEnderMan> {
    private final ModelPart stemBody;

    public WarpedEndermanModel(ModelPart root) {
        super(root);
        this.stemBody = this.body.getChild("stem_body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)-14.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartPose partpose = PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f);
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), partpose);
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), partpose);
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f), PartPose.offset((float)0.0f, (float)-14.0f, (float)0.0f));
        PartDefinition stemBody = body.addOrReplaceChild("stem_body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)39.0f, (float)0.0f));
        stemBody.addOrReplaceChild("stem_body_r1", CubeListBuilder.create().texOffs(42, 0).addBox(-6.0f, -14.0f, -0.5f, 6.0f, 15.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-4.0f, (float)-40.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 30.0f, 2.0f), PartPose.offset((float)-5.0f, (float)-12.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(56, 0).mirror().addBox(-1.0f, -2.0f, -1.0f, 2.0f, 30.0f, 2.0f), PartPose.offset((float)5.0f, (float)-12.0f, (float)0.0f));
        leftArm.addOrReplaceChild("stem_arm", CubeListBuilder.create().texOffs(35, 0).addBox(-4.0f, -38.0f, -0.5f, 6.0f, 15.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)5.0f, (float)37.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 30.0f, 2.0f), PartPose.offset((float)-2.0f, (float)-5.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(56, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 30.0f, 2.0f), PartPose.offset((float)2.0f, (float)-5.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(WarpedEnderMan warpedEnderMan, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)warpedEnderMan, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float f = ageInTicks / 60.0f;
        float degreesToRadians = (float)Math.PI / 180;
        this.stemBody.yRot = degreesToRadians * Mth.sin((float)(f * 3.5f)) * 5.0f;
    }
}

