/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config;

import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.config.lists.ModuleSelectionList;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class UserConfigScreen
extends Screen {
    private static final Component TITLE_TEXT = Component.translatable((String)"screen.config.user.title");
    private static final Component CLOSE_TEXT = Component.translatable((String)"screen.config.close");
    private static final Component FEATURES_TEXT = Component.translatable((String)"screen.config.features");
    public static final float SPLIT = 0.3f;
    private Screen parent;
    private ModuleSelectionList moduleSelectionList;
    public static boolean hasChanged;

    public UserConfigScreen(Screen parent) {
        super(TITLE_TEXT);
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.moduleSelectionList = new ModuleSelectionList(this.minecraft, this.width, this.height, 45, 30);
        for (IModule module : ModRoot.get().modules.getAll()) {
            this.moduleSelectionList.addEntry(new ModuleSelectionList.UserEntry(module));
        }
        this.addRenderableWidget((GuiEventListener)this.moduleSelectionList);
        Button closeButton = Button.builder((Component)CLOSE_TEXT, btn -> this.onClose()).pos(this.width / 2 - 100, this.height - 28).width(200).build();
        this.addRenderableWidget((GuiEventListener)closeButton);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(this.font, TITLE_TEXT, this.width / 2, 10, 0xFFFFFF);
        graphics.drawCenteredString(this.font, FEATURES_TEXT, this.width / 2, 30, 0xFFFFFF);
    }

    public void onClose() {
        this.moduleSelectionList.saveAll();
        if (hasChanged) {
            GlobalConfigs.reloadConfigs();
            hasChanged = false;
        }
        this.minecraft.setScreen(this.parent);
    }
}

