/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;

public class FieryCuttingRecipe
extends CuttingBoardRecipe {
    private final Level level;
    private final Vec3 pos;

    public static Optional<RecipeHolder<CuttingBoardRecipe>> transform(Level level, Vec3 pos, Optional<RecipeHolder<CuttingBoardRecipe>> optional) {
        return optional.map(h -> new RecipeHolder(h.id(), (Recipe)new FieryCuttingRecipe(level, pos, (CuttingBoardRecipe)h.value())));
    }

    private static Ingredient extract(NonNullList<Ingredient> ingredients) {
        return ingredients.isEmpty() ? Ingredient.EMPTY : (Ingredient)ingredients.getFirst();
    }

    private FieryCuttingRecipe(Level level, Vec3 pos, CuttingBoardRecipe recipe) {
        super(recipe.getGroup(), FieryCuttingRecipe.extract((NonNullList<Ingredient>)recipe.getIngredients()), recipe.getTool(), recipe.getRollableResults(), recipe.getSoundEvent());
        this.level = level;
        this.pos = pos;
    }

    public List<ItemStack> rollResults(RandomSource rand, int fortuneLevel) {
        List prev = super.rollResults(rand, fortuneLevel);
        ArrayList<ItemStack> ans = new ArrayList<ItemStack>();
        int particle = 0;
        for (ItemStack stack : prev) {
            SingleRecipeInput cont = new SingleRecipeInput(stack);
            Optional opt = this.level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)cont, this.level);
            if (opt.isEmpty()) {
                ans.add(stack);
                continue;
            }
            ItemStack result = ((SmeltingRecipe)((RecipeHolder)opt.get()).value()).assemble(cont, (HolderLookup.Provider)this.level.registryAccess());
            result.setCount(stack.getCount());
            ans.add(result);
            particle += stack.getCount();
        }
        if (particle > 0) {
            this.spawnParticlesAndPlaySound(particle);
        }
        return ans;
    }

    private void spawnParticlesAndPlaySound(int particle) {
        this.spawnCuttingParticles(particle);
        this.playSound(SoundEvents.FIRE_EXTINGUISH, 1.0f, 1.0f);
    }

    private void playSound(SoundEvent sound, float volume, float pitch) {
        if (this.level != null) {
            this.level.playSound(null, this.pos.x(), this.pos.y(), this.pos.z(), sound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    private void spawnCuttingParticles(int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 vec3d = new Vec3(((double)this.level.random.nextFloat() - 0.5) * 0.1, (double)this.level.random.nextFloat() * 0.05, ((double)this.level.random.nextFloat() - 0.5) * 0.1);
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                sl.sendParticles((ParticleOptions)ParticleTypes.FLAME, this.pos.x(), this.pos.y(), this.pos.z(), 1, vec3d.x, vec3d.y, vec3d.z, 0.0);
                continue;
            }
            this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, this.pos.x(), this.pos.y(), this.pos.z(), vec3d.x, vec3d.y, vec3d.z);
        }
    }
}

