/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.xkmc.twilightdelight.init.registrate.TDBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;

@Mixin(value={CookingPotBlockEntity.class})
public abstract class CookingPotBlockEntityMixin
extends SyncedBlockEntity
implements HeatableBlockEntity {
    @Shadow(remap=false)
    private int cookTime;
    @Shadow(remap=false)
    @Final
    private ItemStackHandler inventory;
    @Shadow(remap=false)
    private int cookTimeTotal;

    @Shadow(remap=false)
    protected abstract boolean hasInput();

    @Shadow(remap=false)
    public abstract boolean isHeated();

    @Shadow(remap=false)
    protected abstract Optional<CookingPotRecipe> getMatchingRecipe(RecipeWrapper var1);

    @Shadow(remap=false)
    protected abstract boolean canCook(CookingPotRecipe var1);

    @Shadow(remap=false)
    protected abstract boolean processCooking(RecipeHolder<CookingPotRecipe> var1, CookingPotBlockEntity var2);

    @Shadow(remap=false)
    public abstract ItemStack getMeal();

    @Shadow(remap=false)
    protected abstract boolean doesMealHaveContainer(ItemStack var1);

    @Shadow(remap=false)
    protected abstract void moveMealToOutput();

    @Shadow(remap=false)
    protected abstract void useStoredContainersOnMeal();

    public CookingPotBlockEntityMixin(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Inject(at={@At(value="HEAD")}, method={"processCooking"}, remap=false)
    public void twilightdelight$processCooking$fasterCooking(RecipeHolder<CookingPotRecipe> recipe, CookingPotBlockEntity cookingPot, CallbackInfoReturnable<Boolean> cir) {
        Item item;
        ResourceLocation id;
        boolean maze;
        if (this.level == null) {
            return;
        }
        BlockState below = this.level.getBlockState(this.getBlockPos().below());
        boolean fiery = this.getBlockState().is((Block)TDBlocks.FIERY_POT.get());
        boolean bl = maze = below.getBlock() == TDBlocks.MAZE_STOVE.get();
        if ((fiery || maze) && ((id = BuiltInRegistries.ITEM.getKey((Object)(item = ((CookingPotRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).getItem()))).getNamespace().equals("twilightforest") || id.getNamespace().equals("twilightdelight"))) {
            int time = ((CookingPotRecipe)recipe.value()).getCookTime();
            if (fiery) {
                time = Math.min(200, time);
            }
            if (maze) {
                time /= 2;
            }
            int total = Math.max(1, time);
            int factor = ((CookingPotRecipe)recipe.value()).getCookTime() / total;
            this.cookTime += factor - 1;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isHeated"}, remap=false, cancellable=true)
    public void twilightdelight$isHeated$fieryPot(CallbackInfoReturnable<Boolean> cir) {
        if (this.getBlockState().is((Block)TDBlocks.FIERY_POT.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lvectorwing/farmersdelight/common/block/entity/CookingPotBlockEntity;isHeated(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z")}, method={"cookingTick", "animationTick"})
    private static boolean twilightdelight$animationTick$isHeated(CookingPotBlockEntity instance, Level level, BlockPos pos, Operation<Boolean> original) {
        if (instance.getBlockState().is((Block)TDBlocks.FIERY_POT.get())) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance, level, pos});
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;is(Lnet/minecraft/world/item/Item;)Z")}, method={"getMealFromItem", "takeServingFromItem", "getContainerFromItem"})
    private static boolean twilightDelight$getMealFromItem$fiery(ItemStack stack, Item item, Operation<Boolean> old) {
        return stack.is(TDBlocks.FIERY_POT.asItem()) || (Boolean)old.call(new Object[]{stack, item}) != false;
    }
}

