/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.events;

import dev.xkmc.twilightdelight.init.data.ExtraLootGen;
import dev.xkmc.twilightdelight.init.registrate.TDEffects;
import dev.xkmc.twilightdelight.init.registrate.TDItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import twilightforest.block.Experiment115Block;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFMobEffects;
import vectorwing.farmersdelight.common.tag.ModTags;

@EventBusSubscriber(modid="twilightdelight", bus=EventBusSubscriber.Bus.GAME)
public class GeneralEventHandlers {
    private static ObjectArrayList<ItemStack> getLoot(ServerLevel sl, ResourceKey<LootTable> id, BlockState state, PlayerInteractEvent.RightClickBlock event) {
        LootParams ctx = new LootParams.Builder(sl).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)event.getPos())).withParameter(LootContextParams.TOOL, (Object)event.getItemStack()).withParameter(LootContextParams.THIS_ENTITY, (Object)event.getEntity()).create(LootContextParamSets.BLOCK);
        return sl.getServer().reloadableRegistries().getLootTable(id).getRandomItems(ctx);
    }

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getLevel().getBlockState(event.getPos());
        if (state.is((Block)TFBlocks.EXPERIMENT_115.get()) && event.getItemStack().is(Items.REDSTONE) && !((Boolean)state.getValue((Property)Experiment115Block.REGENERATE)).booleanValue() && (Integer)state.getValue((Property)Experiment115Block.BITES_TAKEN) > 0) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
        }
        if (event.getItemStack().is(ModTags.KNIVES) && state.is((Block)TFBlocks.EXPERIMENT_115.get())) {
            Level level = event.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                int i = (Integer)state.getValue((Property)Experiment115Block.BITES_TAKEN);
                if (i < 7) {
                    event.getLevel().setBlock(event.getPos(), (BlockState)state.setValue((Property)Experiment115Block.BITES_TAKEN, (Comparable)Integer.valueOf(i + 1)), 3);
                } else {
                    event.getLevel().removeBlock(event.getPos(), false);
                }
                ObjectArrayList<ItemStack> loot = GeneralEventHandlers.getLoot(sl, ExtraLootGen.SCRAP_115, state, event);
                for (ItemStack e : loot) {
                    event.getEntity().getInventory().placeItemBackInInventory(e);
                }
                event.getItemStack().hurtAndBreak(1, (LivingEntity)event.getEntity(), LivingEntity.getSlotForHand((InteractionHand)event.getHand()));
            }
            event.getLevel().playSound(event.getEntity(), event.getPos(), SoundEvents.WOOL_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onPotionTest(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance() == null) {
            return;
        }
        if (event.getEffectInstance().getEffect() == MobEffects.POISON && event.getEntity().hasEffect(TDEffects.POISON_RANGE)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
        if (event.getEffectInstance().getEffect() == TFMobEffects.FROSTY.get() && event.getEntity().hasEffect(TDEffects.FROZEN_RANGE)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    @SubscribeEvent
    public static void onKnightmetalToolDamage(LivingIncomingDamageEvent event) {
        LivingEntity living;
        ItemStack weapon;
        Entity var3;
        LivingEntity target;
        LivingEntity living2;
        ItemStack item;
        Entity entity = event.getSource().getDirectEntity();
        if (entity instanceof LivingEntity && ((item = (living2 = (LivingEntity)entity).getMainHandItem()).is((Item)TDItems.FIERY_KNIFE.get()) || item.is((Item)TDItems.TEARDROP_SWORD.get())) && !event.getEntity().fireImmune()) {
            event.getEntity().setRemainingFireTicks(20);
        }
        if (!(target = event.getEntity()).level().isClientSide() && (var3 = event.getSource().getDirectEntity()) instanceof LivingEntity && !(weapon = (living = (LivingEntity)var3).getMainHandItem()).isEmpty() && target.getArmorValue() > 0 && weapon.is((Item)TDItems.KNIGHTMETAL_KNIFE.get())) {
            if (target.getArmorCoverPercentage() > 0.0f) {
                int moreBonus = (int)(2.0f * target.getArmorCoverPercentage());
                event.setAmount(event.getAmount() + (float)moreBonus);
            } else {
                event.setAmount(event.getAmount() + 2.0f);
            }
            ((ServerLevel)target.level()).getChunkSource().broadcastAndSend((Entity)target, (Packet)new ClientboundAnimatePacket((Entity)target, 5));
        }
    }
}

