/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.mixin.entities;

import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.sashakyotoz.bedrockoid.BedrockoidConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public class MobEntityMixin {
    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleInteraction(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Mob entity = (Mob)this;
        if (BedrockoidConfig.shulkersCanBeDyed && entity instanceof Shulker) {
            Shulker shulker = (Shulker)entity;
            Item item = player.getItemInHand(hand).getItem();
            if (item instanceof DyeItem) {
                DyeItem item2 = (DyeItem)item;
                if (shulker.getColor() != item2.getDyeColor()) {
                    shulker.setVariant(Optional.of(item2.getDyeColor()));
                    player.getItemInHand(hand).shrink(1);
                    cir.setReturnValue((Object)InteractionResult.CONSUME);
                } else {
                    cir.setReturnValue((Object)InteractionResult.PASS);
                }
            }
        }
    }
}

