/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.mixin.entities;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.sashakyotoz.bedrockoid.BedrockoidConfig;
import net.sashakyotoz.bedrockoid.common.utils.BlockUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    private void handleTick(CallbackInfo ci) {
        BlockState state;
        Entity entity = (Entity)this;
        if (entity.isOnFire() && BedrockoidConfig.entitySharesFire && ((state = entity.level().getBlockState(entity.getOnPos())).getBlock() instanceof CampfireBlock || state.getBlock() instanceof AbstractCandleBlock) && !((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            entity.level().setBlockAndUpdate(entity.getOnPos(), (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
            entity.playSound(SoundEvents.FLINTANDSTEEL_USE);
        }
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")})
    private void primeTntOnRails(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Entity entity = (Entity)this;
        Level level = player.level();
        ItemStack stack = player.getItemInHand(hand);
        if (entity instanceof MinecartTNT) {
            MinecartTNT tnt = (MinecartTNT)entity;
            if (level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.FIRE_ASPECT).isPresent() && EnchantmentHelper.getTagEnchantmentLevel((Holder)((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.FIRE_ASPECT).get()), (ItemStack)stack) > 0 && BedrockoidConfig.fireAspectImprovements) {
                stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                tnt.primeFuse();
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            }
        }
    }

    @WrapOperation(method={"spawnSprintParticle"}, at={@At(value="NEW", target="(Lnet/minecraft/core/particles/ParticleType;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/core/particles/BlockParticleOption;")})
    public BlockParticleOption spawnSprintParticle(ParticleType type, BlockState blockState, Operation<BlockParticleOption> original) {
        if (BlockUtils.isSnowlogged(blockState) && BedrockoidConfig.snowlogging) {
            blockState = BlockUtils.getSnowEquivalent(blockState);
        }
        return (BlockParticleOption)original.call(new Object[]{type, blockState});
    }
}

