/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.mixin.client;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.bedrockoid.BedrockoidConfig;
import net.sashakyotoz.bedrockoid.common.utils.ModsUtils;
import net.sashakyotoz.bedrockoid.common.utils.ReachPlacementUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin
extends ReentrantBlockableEventLoop<Runnable> {
    @Shadow
    public LocalPlayer player;
    @Shadow
    @Nullable
    public HitResult hitResult;

    public MinecraftClientMixin(String string) {
        super(string);
    }

    @Inject(method={"startUseItem"}, at={@At(value="HEAD")})
    private void crosshairTargetHandling(CallbackInfo ci) {
        if (this.player == null || ModsUtils.isBedrockifyIn() || !BedrockoidConfig.reachAroundPlacement) {
            return;
        }
        if (ReachPlacementUtils.INSTANCE.canReachAround()) {
            LocalPlayer player = this.player;
            BlockPos targetPos = ReachPlacementUtils.getFacingSteppingBlockPos((Entity)player);
            this.hitResult = new BlockHitResult(new Vec3((double)targetPos.getX(), player.getY(), (double)targetPos.getZ()), player.getDirection(), targetPos, false);
        }
    }
}

