/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.mixin.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.sashakyotoz.bedrockoid.BedrockoidConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={SugarCaneBlock.class})
public abstract class SugarcaneBlockMixin
implements BonemealableBlock {
    @Shadow
    protected abstract boolean canSurvive(BlockState var1, LevelReader var2, BlockPos var3);

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState blockState) {
        return level.getBlockState(pos.above()).isAir() && pos.getY() + 1 < level.getHeight() && BedrockoidConfig.canSugarcaneBeBonemeal;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos pos, BlockState state) {
        return this.canSurvive(state, (LevelReader)level, pos) && level.getBlockState(pos.above()).isAir() && BedrockoidConfig.canSugarcaneBeBonemeal;
    }

    public void performBonemeal(ServerLevel level, RandomSource randomSource, BlockPos pos, BlockState state) {
        if (level.getBlockState(pos.above()).isAir()) {
            level.setBlock(pos.above(), state, 3);
        }
    }
}

