/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.mixin.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.sashakyotoz.bedrockoid.BedrockoidConfig;
import net.sashakyotoz.bedrockoid.common.utils.BlockUtils;
import net.sashakyotoz.bedrockoid.common.utils.ModsUtils;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={FlowerBlock.class})
public class FlowerBlockMixin
implements BonemealableBlock {
    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return !blockState.is(Blocks.WITHER_ROSE);
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource random, BlockPos blockPos, BlockState blockState) {
        if (!ModsUtils.isBedrockifyIn() && BedrockoidConfig.canPlantsBeBonemeal && !BlockUtils.isSnowlogged(blockState)) {
            int amount = random.nextIntBetweenInclusive(1, 5);
            for (int i = 0; i < amount; ++i) {
                int z;
                int x = random.nextIntBetweenInclusive(-3, 3);
                BlockPos newPos = blockPos.offset(x, 0, z = random.nextIntBetweenInclusive(-3, 3));
                if (!serverLevel.getBlockState(newPos).isAir() || !serverLevel.getBlockState(newPos.below()).is(BlockTags.DIRT)) continue;
                serverLevel.setBlockAndUpdate(newPos, blockState);
            }
        }
    }
}

