/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.mixin.blocks;

import com.google.common.base.Predicate;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.WetSpongeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.sashakyotoz.bedrockoid.BedrockoidConfig;
import net.sashakyotoz.bedrockoid.common.utils.BlockUtils;
import net.sashakyotoz.bedrockoid.common.utils.ModsUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateMixin {
    @Shadow
    protected abstract BlockState asState();

    @Inject(method={"updateShape"}, at={@At(value="HEAD")})
    private void onUpdateShape(Direction direction, BlockState state, LevelAccessor world, BlockPos pos, BlockPos neighborPos, CallbackInfoReturnable<BlockState> cir) {
        if (world.getBlockState(pos).hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)world.getBlockState(pos).getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && BedrockoidConfig.blocksWaterloggability) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
    }

    @Inject(method={"getFluidState"}, at={@At(value="HEAD")}, cancellable=true)
    private void applyWaterloggability(CallbackInfoReturnable<FluidState> cir) {
        BlockBehaviour.BlockStateBase block = (BlockBehaviour.BlockStateBase)this;
        if (BlockUtils.isInstanceOfAny(block.getBlock()) && block.hasProperty((Property)BlockStateProperties.WATERLOGGED) && BedrockoidConfig.blocksWaterloggability) {
            cir.setReturnValue((Object)((Boolean)block.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState()));
        }
    }

    @ModifyReturnValue(method={"getShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="RETURN")})
    private VoxelShape getCollisionShape(VoxelShape original, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockState blockState = this.asState();
        if (BlockUtils.isSnowlogged(blockState) && !ModsUtils.isSodiumIn()) {
            return Shapes.or((VoxelShape)original, (VoxelShape)BlockUtils.getSnowEquivalent(blockState).getCollisionShape(world, pos, context));
        }
        return original;
    }

    @ModifyReturnValue(method={"getVisualShape"}, at={@At(value="RETURN")})
    private VoxelShape getVisualShape(VoxelShape original, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockState blockState = this.asState();
        if (BlockUtils.isSnowlogged(blockState) && !ModsUtils.isSodiumIn()) {
            return Shapes.or((VoxelShape)original, (VoxelShape)BlockUtils.getSnowEquivalent(blockState).getShape(world, pos, context));
        }
        return original;
    }

    @Inject(method={"randomTick"}, at={@At(value="TAIL")})
    private void randomTick(ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof WetSpongeBlock && BedrockoidConfig.wetSpongesDryOut && !BlockUtils.isTouchingBlock((Level)level, pos, (Predicate<BlockState>)((Predicate)block -> block != null && block.getFluidState().is(FluidTags.WATER))) && random.nextInt(12) == 5 && !((Biome)level.getBiome(pos).value()).hasPrecipitation() && ((Biome)level.getBiome(pos).value()).getBaseTemperature() >= 0.75f) {
            level.setBlock(pos, Blocks.SPONGE.defaultBlockState(), 3);
            level.levelEvent(2009, pos, 0);
            level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, (1.0f + level.getRandom().nextFloat() * 0.2f) * 0.7f);
        }
        if (BlockUtils.haveToFillUpCauldron(state, level, pos) && state.getBlock() instanceof LayeredCauldronBlock && BedrockoidConfig.cauldronNaturalFilling) {
            BlockState blockState = (BlockState)state.cycle((Property)BlockStateProperties.LEVEL_CAULDRON);
            level.setBlockAndUpdate(pos, blockState);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockState));
        }
    }

    @Inject(method={"isRandomlyTicking"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasRandomTicks(CallbackInfoReturnable<Boolean> cir) {
        BlockBehaviour.BlockStateBase block = (BlockBehaviour.BlockStateBase)this;
        if (block.getBlock() instanceof WetSpongeBlock && BedrockoidConfig.wetSpongesDryOut || block.getBlock() instanceof AbstractCauldronBlock && BedrockoidConfig.cauldronNaturalFilling) {
            cir.setReturnValue((Object)true);
        }
    }
}

