/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.mixin.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.sashakyotoz.bedrockoid.BedrockoidConfig;
import net.sashakyotoz.bedrockoid.common.utils.BlockUtils;
import net.sashakyotoz.bedrockoid.common.utils.ModsUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.class}, priority=900)
public abstract class BlockMixin {
    @Shadow
    private BlockState defaultBlockState;

    @Inject(method={"registerDefaultState"}, at={@At(value="TAIL")})
    private void addSnowLayers(BlockState state, CallbackInfo ci) {
        Block block = state.getBlock();
        if (block instanceof BushBlock && block.getStateDefinition().getProperties().contains(BlockUtils.LAYERS) && BedrockoidConfig.snowlogging) {
            this.defaultBlockState = (BlockState)state.setValue((Property)BlockUtils.LAYERS, (Comparable)Integer.valueOf(0));
        }
        if (BlockUtils.isInstanceOfAny(block) && block.getStateDefinition().getProperties().contains(BlockStateProperties.WATERLOGGED) && BedrockoidConfig.blocksWaterloggability) {
            this.defaultBlockState = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
    }

    @Inject(method={"createBlockStateDefinition"}, at={@At(value="HEAD")})
    private void onAppendProperties(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo ci) {
        Block self = (Block)this;
        if (self instanceof BushBlock && ModsUtils.isSnowloggingNotOverrided()) {
            builder.add(new Property[]{BlockUtils.LAYERS});
        }
        if (self instanceof AbstractCauldronBlock) {
            builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
        }
    }

    @Inject(method={"animateTick"}, at={@At(value="HEAD")})
    private void spawnSnowBelow(BlockState state, Level level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (BlockUtils.haveLeavesToChangeColor(state, (BlockAndTintGetter)level, pos) && BedrockoidConfig.snowCoversLeaves && level.getBlockState(pos.below()).isAir() && level.random.nextInt(9) == 4) {
            level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), level.random.nextBoolean() ? (double)0.01f : (double)-0.01f, (double)-0.01f, 0.0);
        }
    }

    @Inject(method={"getStateForPlacement"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetPlacementState(BlockPlaceContext ctx, CallbackInfoReturnable<BlockState> cir) {
        BlockState state = (BlockState)cir.getReturnValue();
        if (state != null && state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && BedrockoidConfig.blocksWaterloggability) {
            FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
            cir.setReturnValue((Object)((BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is(FluidTags.WATER)))));
        }
    }
}

