/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.sashakyotoz.bedrockoid.BedrockoidConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void litBlockWithAspect(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemStack = context.getItemInHand();
        if (context.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.FIRE_ASPECT).isPresent() && EnchantmentHelper.getTagEnchantmentLevel((Holder)((Holder)context.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.FIRE_ASPECT).get()), (ItemStack)itemStack) > 0 && BedrockoidConfig.fireAspectImprovements) {
            BlockPos blockPos;
            Player player = context.getPlayer();
            Level world = context.getLevel();
            BlockState blockState = world.getBlockState(blockPos = context.getClickedPos());
            if (CampfireBlock.canLight((BlockState)blockState) || CandleBlock.canLight((BlockState)blockState) || CandleCakeBlock.canLight((BlockState)blockState)) {
                world.playSound(player, blockPos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.4f + 0.8f);
                world.setBlock(blockPos, (BlockState)blockState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.TRUE), 11);
                world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
                if (player != null) {
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, context.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                }
                cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)world.isClientSide()));
            }
        }
    }
}

