/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.events;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.sashakyotoz.bedrockoid.BedrockoidConfig;
import net.sashakyotoz.bedrockoid.common.snow.BedrockSnowManager;
import net.sashakyotoz.bedrockoid.common.utils.ModsUtils;

@EventBusSubscriber
public class NeoBusEvents {
    @SubscribeEvent
    public static void onStartTick(LevelTickEvent.Pre event) {
        ServerLevel serverLevel;
        Level level = event.getLevel();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).isRaining() && !ModsUtils.isSnowUnderTreesIn()) {
            int randomTickSpeed = serverLevel.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
            BedrockSnowManager.runForChunks(serverLevel, chunk -> NeoBusEvents.addSnowUnderTrees(serverLevel, chunk, randomTickSpeed));
        }
    }

    private static void addSnowUnderTrees(ServerLevel level, LevelChunk chunk, int randomTickSpeed) {
        ChunkPos chunkPos = chunk.getPos();
        int chunkX = chunkPos.getMinBlockX();
        int chunkZ = chunkPos.getMaxBlockZ();
        randomTickSpeed = Math.min(randomTickSpeed, 50);
        for (int i = 0; i < randomTickSpeed; ++i) {
            BlockPos posBelow;
            BlockState stateBelow;
            boolean biomeDisabled;
            BlockPos randomPos;
            if (level.random.nextInt(32) != 0 || !level.getBlockState(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, randomPos = level.getBlockRandomPos(chunkX, 0, chunkZ, 15)).below()).is(BlockTags.LEAVES)) continue;
            BlockPos pos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, randomPos);
            Biome biome = (Biome)level.getBiome(pos).value();
            boolean bl = biomeDisabled = level.registryAccess().registry(Registries.BIOME).isPresent() && BedrockoidConfig.disableSnowUnderTreesIn.contains(((Registry)level.registryAccess().registry(Registries.BIOME).get()).getKey((Object)biome).toString());
            if (biomeDisabled || !BedrockSnowManager.placeSnow((WorldGenLevel)level, pos) || !(stateBelow = level.getBlockState(posBelow = pos.below())).hasProperty((Property)SnowyDirtBlock.SNOWY)) continue;
            level.setBlock(posBelow, (BlockState)stateBelow.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true)), 2);
        }
    }
}

