/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.events;

import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.sashakyotoz.bedrockoid.BedrockoidConfig;
import net.sashakyotoz.bedrockoid.common.utils.BlockUtils;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class BedrockoidModBusClient {
    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, index) -> {
            if (BedrockoidConfig.snowCoversLeaves) {
                return BlockUtils.leavesSnowyColor(state, pos);
            }
            return level != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)pos) : FoliageColor.getDefaultColor();
        }, new Block[]{Blocks.OAK_LEAVES, Blocks.SPRUCE_LEAVES, Blocks.BIRCH_LEAVES, Blocks.JUNGLE_LEAVES, Blocks.ACACIA_LEAVES, Blocks.DARK_OAK_LEAVES, Blocks.MANGROVE_LEAVES, Blocks.AZALEA_LEAVES, Blocks.FLOWERING_AZALEA_LEAVES});
        event.register((state, world, pos, index) -> {
            if (BlockUtils.isSnowlogged(state) || world != null && pos != null && BlockUtils.isSnowlogged(world.getBlockState(pos.below())) && BedrockoidConfig.snowlogging) {
                return 0xCCCCCC;
            }
            return world != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.getDefaultColor();
        }, new Block[]{Blocks.GLASS, Blocks.TALL_GRASS, Blocks.FERN, Blocks.LARGE_FERN});
        event.register((state, world, pos, index) -> {
            if (BlockUtils.canVinesBeCoveredInSnow(state, world, pos) && BedrockoidConfig.snowCoversVines) {
                return 0xCCCCCC;
            }
            return world != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)world, (BlockPos)pos) : FoliageColor.getDefaultColor();
        }, new Block[]{Blocks.VINE});
    }
}

