/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.common.world.features.custom;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.sashakyotoz.bedrockoid.common.snow.BedrockSnowManager;
import net.sashakyotoz.bedrockoid.common.utils.ModsUtils;

public class SnowUnderTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public static final Feature<NoneFeatureConfiguration> INSTANCE = new SnowUnderTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC);

    public SnowUnderTreeFeature(Codec<NoneFeatureConfiguration> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        BlockPos pos = ctx.origin();
        WorldGenLevel level = ctx.level();
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        if (!ModsUtils.isSnowUnderTreesIn()) {
            for (int xi = 0; xi < 16; ++xi) {
                for (int zi = 0; zi < 16; ++zi) {
                    int x = pos.getX() + xi;
                    int z = pos.getZ() + zi;
                    mPos.set(x, level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z) - 1, z);
                    if (!level.getBlockState((BlockPos)mPos).is(BlockTags.LEAVES)) continue;
                    mPos.set(x, level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z), z);
                    if (!BedrockSnowManager.placeSnow(level, (BlockPos)mPos)) continue;
                    mPos.move(Direction.DOWN);
                    BlockState stateBelow = level.getBlockState((BlockPos)mPos);
                    if (!stateBelow.hasProperty((Property)SnowyDirtBlock.SNOWY)) continue;
                    level.setBlock((BlockPos)mPos, (BlockState)stateBelow.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true)), 2);
                }
            }
        }
        return true;
    }
}

