/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.common.utils;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.bedrockoid.Bedrockoid;
import org.jetbrains.annotations.NotNull;

public class ReachPlacementUtils {
    public static final ReachPlacementUtils INSTANCE = new ReachPlacementUtils();
    private final Minecraft client = Minecraft.getInstance();
    public static final ResourceLocation PLACEMENT_ICON = Bedrockoid.makeID("textures/gui/reach_around_icon.png");

    public void renderIndicator(GuiGraphics drawContext) {
        if (this.canReachAround()) {
            drawContext.blit(PLACEMENT_ICON, drawContext.guiWidth() / 2 - 8, drawContext.guiHeight() / 2 - 8, 0.0f, 0.0f, 15, 15, 15, 15);
        }
    }

    public boolean canReachAround() {
        if (this.client.player == null || this.client.level == null || this.client.hitResult == null) {
            return false;
        }
        if (!this.client.hitResult.getType().equals((Object)HitResult.Type.MISS)) {
            return false;
        }
        LocalPlayer player = this.client.player;
        BlockPos targetPos = ReachPlacementUtils.getFacingSteppingBlockPos((Entity)player);
        if (!player.isCrouching()) {
            return false;
        }
        if (player.getMainHandItem().isEmpty() && player.getOffhandItem().isEmpty()) {
            return false;
        }
        if (!player.onGround()) {
            return false;
        }
        if (!this.client.level.getBlockState(targetPos).canBeReplaced()) {
            return false;
        }
        return this.getRaycastIntersection(player).isPresent();
    }

    public static BlockPos getFacingSteppingBlockPos(@NotNull Entity player) {
        return player.getOnPos().relative(player.getDirection());
    }

    private Optional<Vec3> getRaycastIntersection(@NotNull LocalPlayer player) {
        Vec3 rayStartPos = player.getEyePosition();
        Vec3 rayEndPos = player.getViewVector(1.0f).scale(4.5).add(rayStartPos);
        return new AABB(ReachPlacementUtils.getFacingSteppingBlockPos((Entity)player)).clip(rayStartPos, rayEndPos);
    }
}

