/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.common.utils;

import com.google.common.base.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.sashakyotoz.bedrockoid.common.utils.ModsUtils;
import org.jetbrains.annotations.Nullable;

public class BlockUtils {
    public static final IntegerProperty LAYERS = IntegerProperty.create((String)"snow_layers", (int)0, (int)8);
    private static final Class<?>[] WATERLOGGED_MISSING_BLOCKS = new Class[]{LayeredCauldronBlock.class, AbstractCauldronBlock.class, AnvilBlock.class, BedBlock.class, PressurePlateBlock.class, FenceGateBlock.class, LecternBlock.class, BrewingStandBlock.class, HopperBlock.class, GrindstoneBlock.class, StonecutterBlock.class};

    public static boolean isSnowlogged(@Nullable BlockState state) {
        return state != null && state.hasProperty((Property)LAYERS) && (Integer)state.getValue((Property)LAYERS) > 0 && ModsUtils.isSnowloggingNotOverrided();
    }

    public static BlockState getSnowEquivalent(BlockState state) {
        return (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf(Math.max(1, (Integer)state.getValue((Property)LAYERS))));
    }

    public static boolean canSnowlog(@Nullable BlockState state) {
        return state != null && state.getProperties() != null && state.hasProperty((Property)LAYERS) && state.getFluidState().isEmpty() && ModsUtils.isSnowloggingNotOverrided();
    }

    public static boolean isTouchingBlock(Level level, BlockPos pos, Predicate<BlockState> predicate) {
        for (Direction dir : Direction.values()) {
            BlockState state = level.getBlockState(pos.relative(dir));
            if (!predicate.test((Object)state)) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canVinesBeCoveredInSnow(BlockState state, BlockAndTintGetter getter, BlockPos pos) {
        Minecraft minecraft = Minecraft.getInstance();
        if (pos != null && minecraft.level != null) {
            return state.getBlock() instanceof VineBlock && minecraft.level.getBiome(pos) != null && ((Biome)minecraft.level.getBiome(pos).value()).getBaseTemperature() < 0.15f && ((Biome)minecraft.level.getBiome(pos).value()).hasPrecipitation();
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean haveLeavesToChangeColor(BlockState state, BlockAndTintGetter getter, BlockPos pos) {
        if (getter != null && pos != null) {
            BlockState upperState = getter.getBlockState(pos.above());
            return state.getBlock() instanceof LeavesBlock && upperState.is(Blocks.SNOW) || upperState.getBlock() instanceof LeavesBlock && getter.getBlockState(pos.above(2)).is(Blocks.SNOW);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int leavesSnowyColor(BlockState state, BlockPos pos) {
        ClientLevel level = Minecraft.getInstance().level;
        if (state.getBlock() instanceof LeavesBlock && level != null && pos != null) {
            BlockState upperState = level.getBlockState(pos.above());
            if (upperState.is(Blocks.SNOW) || upperState.getBlock() instanceof LeavesBlock && level.getBlockState(pos.above(2)).is(Blocks.SNOW)) {
                return BlockUtils.blendColors(BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)pos), 0xFFFFFF, 0.95f);
            }
            if (((Biome)level.getBiome(pos).value()).getBaseTemperature() < 0.1f && ((Biome)level.getBiome(pos).value()).hasPrecipitation()) {
                return BlockUtils.getNeighborBlocks(level, pos) ? BlockUtils.blendColors(BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)pos), 0xFFFFFF, 0.4f) : BlockUtils.blendColors(BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)pos), 0xFFFFFF, 0.75f);
            }
        }
        return level != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)pos) : FoliageColor.getDefaultColor();
    }

    private static boolean getNeighborBlocks(ClientLevel level, BlockPos pos) {
        return ((Biome)level.getBiome(pos.north()).value()).getBaseTemperature() > 0.1f || ((Biome)level.getBiome(pos.south()).value()).getBaseTemperature() > 0.1f || ((Biome)level.getBiome(pos.east()).value()).getBaseTemperature() > 0.1f || ((Biome)level.getBiome(pos.west()).value()).getBaseTemperature() > 0.1f;
    }

    public static int blendColors(int colorA, int colorB, float t) {
        t = Math.max(0.0f, Math.min(1.0f, t));
        int r = (int)((float)(colorA >> 16 & 0xFF) * (1.0f - t) + (float)(colorB >> 16 & 0xFF) * t);
        int g = (int)((float)(colorA >> 8 & 0xFF) * (1.0f - t) + (float)(colorB >> 8 & 0xFF) * t);
        int b = (int)((float)(colorA & 0xFF) * (1.0f - t) + (float)(colorB & 0xFF) * t);
        return r << 16 | g << 8 | b;
    }

    public static boolean haveToFillUpCauldron(BlockState state, ServerLevel world, BlockPos pos) {
        if (world.getFluidState(pos.above()).is((Fluid)Fluids.WATER) && state.is(Blocks.WATER_CAULDRON) && (Integer)state.getValue((Property)BlockStateProperties.LEVEL_CAULDRON) != 3) {
            return true;
        }
        if (world.getFluidState(pos.above()).is((Fluid)Fluids.WATER) && state.is(Blocks.CAULDRON)) {
            world.setBlock(pos, (BlockState)((BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)BlockStateProperties.LEVEL_CAULDRON, (Comparable)Integer.valueOf(1))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
            return true;
        }
        if (world.getFluidState(pos.above()).is((Fluid)Fluids.LAVA) && state.is(Blocks.CAULDRON) && world.getGameRules().getBoolean(GameRules.RULE_LAVA_SOURCE_CONVERSION)) {
            world.setBlock(pos, Blocks.LAVA_CAULDRON.defaultBlockState(), 3);
            return true;
        }
        return false;
    }

    public static boolean isInstanceOfAny(Block block) {
        for (Class<?> clazz : WATERLOGGED_MISSING_BLOCKS) {
            if (!clazz.isInstance(block)) continue;
            return true;
        }
        return false;
    }
}

