/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.common.snow.snow_managers;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.sashakyotoz.bedrockoid.common.snow.BedrockSnowManager;
import net.sashakyotoz.bedrockoid.common.snow.snow_managers.SnowManager;
import net.sashakyotoz.bedrockoid.common.utils.BlockUtils;

public class VanillaManager
implements SnowManager {
    @Override
    public boolean placeSnow(WorldGenLevel level, BlockPos pos) {
        int accumulationHeight;
        if (level instanceof Level) {
            Level l = (Level)level;
            v0 = l.getGameRules().getInt(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT);
        } else {
            v0 = accumulationHeight = 1;
        }
        if (accumulationHeight > 0 && BedrockSnowManager.canSnow(level, pos)) {
            BlockState state = level.getBlockState(pos);
            if (state.is(Blocks.SNOW)) {
                int currentLayers = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
                if (currentLayers < Math.min(accumulationHeight, 8)) {
                    BlockState snowLayers = (BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(currentLayers + 1));
                    Block.pushEntitiesUp((BlockState)state, (BlockState)snowLayers, (LevelAccessor)level, (BlockPos)pos);
                    level.setBlock(pos, snowLayers, 2);
                    return true;
                }
            } else {
                if (state.getBlock() instanceof SugarCaneBlock) {
                    return true;
                }
                if (BlockUtils.canSnowlog(state)) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)BlockUtils.LAYERS, (Comparable)Integer.valueOf(1)), 2);
                } else {
                    level.setBlock(pos, level.getBlockState(pos).hasProperty((Property)BlockUtils.LAYERS) ? (BlockState)state.setValue((Property)BlockUtils.LAYERS, (Comparable)Integer.valueOf(1)) : Blocks.SNOW.defaultBlockState(), 2);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSnow(WorldGenLevel level, BlockPos pos) {
        return level.getBlockState(pos).is(Blocks.SNOW);
    }

    @Override
    public BlockState getStateAfterMelting(BlockState stateNow, WorldGenLevel level, BlockPos pos) {
        return Blocks.AIR.defaultBlockState();
    }
}

