/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.bedrockoid.common.snow;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.sashakyotoz.bedrockoid.common.snow.snow_managers.SnowManager;
import net.sashakyotoz.bedrockoid.common.snow.snow_managers.VanillaManager;

public class BedrockSnowManager {
    private static SnowManager snowManager;
    private static ChunkRunner chunkRunner;
    private static BiFunction<WorldGenLevel, BlockPos, Boolean> temperatureCheck;

    public static void init() {
        snowManager = new VanillaManager();
        temperatureCheck = (level, pos) -> !((Biome)level.getBiome(pos).value()).warmEnoughToRain(pos);
        chunkRunner = (level, action) -> level.getChunkSource().chunkMap.getChunks().forEach(chunkHolder -> chunkHolder.getEntityTickingChunkFuture().getNow(ChunkHolder.UNLOADED_LEVEL_CHUNK).ifSuccess(action));
    }

    public static boolean placeSnow(WorldGenLevel level, BlockPos pos) {
        return snowManager.placeSnow(level, pos);
    }

    public static boolean canSnow(WorldGenLevel level, BlockPos pos) {
        Holder biome = level.getBiome(pos);
        if (((Biome)biome.value()).getPrecipitationAt(pos) == Biome.Precipitation.SNOW) {
            BlockState stateAtPos = level.getBlockState(pos);
            if (!stateAtPos.canBeReplaced()) {
                return false;
            }
            if (temperatureCheck.apply(level, pos).booleanValue() && BedrockSnowManager.isInBuildRangeAndDarkEnough(level, pos)) {
                BlockPos posBelow = pos.below();
                BlockState stateBelow = level.getBlockState(posBelow);
                return stateBelow.isFaceSturdy((BlockGetter)level, posBelow, Direction.UP);
            }
        }
        return false;
    }

    public static boolean isSnow(WorldGenLevel level, BlockPos pos) {
        return snowManager.isSnow(level, pos);
    }

    public static BlockState getStateAfterMelting(BlockState stateNow, WorldGenLevel level, BlockPos pos) {
        return snowManager.getStateAfterMelting(stateNow, level, pos);
    }

    private static boolean isInBuildRangeAndDarkEnough(WorldGenLevel level, BlockPos pos) {
        return pos.getY() >= level.getMinBuildHeight() && pos.getY() <= level.getHeight() && level.getBrightness(LightLayer.BLOCK, pos) < 10;
    }

    public static void runForChunks(ServerLevel level, Consumer<LevelChunk> action) {
        ServerChunkCache cache = level.getChunkSource();
        chunkRunner.run(level, chunk -> {
            ChunkPos chunkPos = chunk.getPos();
            if ((level.isNaturalSpawningAllowed(chunkPos) && cache.chunkMap.anyPlayerCloseEnoughForSpawning(chunkPos) || cache.chunkMap.getDistanceManager().inBlockTickingRange(chunkPos.toLong())) && level.shouldTickBlocksAt(chunkPos.toLong())) {
                action.accept((LevelChunk)chunk);
            }
        });
    }

    @FunctionalInterface
    private static interface ChunkRunner {
        public void run(ServerLevel var1, Consumer<LevelChunk> var2);
    }
}

