/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivelanterns;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector4f;
import toni.immersivelanterns.BaseLanternRenderer;
import toni.immersivelanterns.foundation.config.AllConfigs;
import toni.immersivelanterns.foundation.mixin.ModelPartAccessor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class LanternCurioRenderer
extends BaseLanternRenderer
implements ICurioRenderer {
    public static void register() {
        CuriosRendererRegistry.register((Item)Items.LANTERN, LanternCurioRenderer::new);
        CuriosRendererRegistry.register((Item)Items.SOUL_LANTERN, LanternCurioRenderer::new);
    }

    public static boolean isEquipped(Player player) {
        Optional curios = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (!curios.isPresent()) {
            return false;
        }
        return ((ICuriosItemHandler)curios.get()).isEquipped((T stack) -> stack.getItem() == Items.LANTERN || stack.getItem() == Items.SOUL_LANTERN);
    }

    public static ItemStack getEquipped(Player player) {
        if (!LanternCurioRenderer.isEquipped(player)) {
            return null;
        }
        return ((SlotResult)((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get()).findFirstCurio(stack -> stack.getItem() == Items.LANTERN || stack.getItem() == Items.SOUL_LANTERN).get()).stack();
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrices, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            livingEntity = renderLayerParent.getModel();
            if (livingEntity instanceof PlayerModel) {
                float xOffset;
                PlayerModel playerModel = (PlayerModel)livingEntity;
                boolean isWearingArmor = false;
                for (ItemStack armor : player.getArmorSlots()) {
                    if (!armor.is(ItemTags.LEG_ARMOR) && !armor.is(ItemTags.CHEST_ARMOR)) continue;
                    isWearingArmor = true;
                    break;
                }
                float lanternTop = 0.6875f;
                matrices.pushPose();
                float f = xOffset = (Boolean)AllConfigs.client().leftHandedLanterns.get() != false ? 0.1f : 2.0f;
                float zOffset = ((Boolean)AllConfigs.client().backLanterns.get()).booleanValue() ? (isWearingArmor ? -3.1f : -3.0f) : -1.0f;
                Vec3 hipOffset = isWearingArmor ? new Vec3((double)(xOffset + 0.05f), -1.25, (double)(zOffset + 0.05f)) : new Vec3((double)(xOffset - 0.1f), -1.25, (double)(zOffset - 0.1f));
                LanternCurioRenderer.transformToModelPart(matrices, playerModel.body, hipOffset.x, hipOffset.y, hipOffset.z);
                matrices.translate(0.5f, lanternTop, 0.5f);
                Vector4f localPosition = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
                localPosition.mulTranspose((Matrix4fc)matrices.last().pose());
                Vec3 hipPosition = new Vec3((double)localPosition.x(), (double)localPosition.y(), (double)localPosition.z());
                hipPosition = hipPosition.add(player.getPosition(partialTicks));
                Vec3 update = Minecraft.getInstance().screen == null && (Boolean)AllConfigs.client().enablePhysics.get() != false ? this.updatePendulum(player, hipPosition, partialTicks) : Vec3.ZERO;
                double xRot = update.z;
                xRot += (double)(Math.min(0.0f, playerModel.rightLeg.xRot / 3.0f) - ((Boolean)AllConfigs.client().backLanterns.get() != false ? -0.1f : 0.1f));
                matrices.mulPose(new Quaternionf().rotationZYX((float)update.x, 0.0f, (float)(xRot -= (double)playerModel.body.xRot)));
                matrices.translate(-0.5f, -lanternTop, -0.5f);
                BlockState blockstate = Block.byItem((Item)stack.getItem()).defaultBlockState();
                Minecraft.getInstance().getBlockRenderer().renderSingleBlock(blockstate, matrices, multiBufferSource, light, OverlayTexture.NO_OVERLAY);
                matrices.popPose();
            }
        }
    }

    static void transformToModelPart(PoseStack poseStack, ModelPart part, Number xPercent, Number yPercent, Number zPercent) {
        part.translateAndRotate(poseStack);
        Pair<Vec3, Vec3> aabb = LanternCurioRenderer.getAABB(part);
        poseStack.scale(0.0625f, 0.0625f, 0.0625f);
        poseStack.translate(xPercent != null ? Mth.lerp((double)((-xPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).x, (double)((Vec3)aabb.getSecond()).x) : 0.0, yPercent != null ? Mth.lerp((double)((-yPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).y, (double)((Vec3)aabb.getSecond()).y) : 0.0, zPercent != null ? Mth.lerp((double)((-zPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).z, (double)((Vec3)aabb.getSecond()).z) : 0.0);
        poseStack.scale(8.0f, 8.0f, 8.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
    }

    private static Pair<Vec3, Vec3> getAABB(ModelPart part) {
        Vec3 min = new Vec3(0.0, 0.0, 0.0);
        Vec3 max = new Vec3(0.0, 0.0, 0.0);
        if (part.getClass().getSimpleName().contains("EMFModelPart")) {
            ArrayList<ModelPart> parts = new ArrayList<ModelPart>();
            parts.add(part);
            parts.addAll(((ModelPartAccessor)part).getChildren().values());
            for (ModelPart modelPart : parts) {
                for (ModelPart.Cube cube : ((ModelPartAccessor)modelPart).getCubes()) {
                    min = new Vec3(Math.min(min.x, (double)Math.min(cube.minX + modelPart.x, cube.maxX + modelPart.x)), Math.min(min.y, (double)Math.min(cube.minY + modelPart.y, cube.maxY + modelPart.y)), Math.min(min.z, (double)Math.min(cube.minZ + modelPart.z, cube.maxZ + modelPart.z)));
                    max = new Vec3(Math.max(max.x, (double)Math.max(cube.minX + modelPart.x, cube.maxX + modelPart.x)), Math.max(max.y, (double)Math.max(cube.minY + modelPart.y, cube.maxY + modelPart.y)), Math.max(max.z, (double)Math.max(cube.minZ + modelPart.z, cube.maxZ + modelPart.z)));
                }
            }
        } else {
            for (ModelPart.Cube cube : ((ModelPartAccessor)part).getCubes()) {
                min = new Vec3(Math.min(min.x, (double)Math.min(cube.minX, cube.maxX)), Math.min(min.y, (double)Math.min(cube.minY, cube.maxY)), Math.min(min.z, (double)Math.min(cube.minZ, cube.maxZ)));
                max = new Vec3(Math.max(max.x, (double)Math.max(cube.minX, cube.maxX)), Math.max(max.y, (double)Math.max(cube.minY, cube.maxY)), Math.max(max.z, (double)Math.max(cube.minZ, cube.maxZ)));
            }
        }
        return Pair.of((Object)min, (Object)max);
    }
}

