/*
 * Decompiled with CFR 0.152.
 */
package toni.earlybedtime;

import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import toni.earlybedtime.foundation.config.AllConfigs;

@Mod(value="earlybedtime")
public class EarlyBedtime {
    public static final String MODNAME = "Early Bedtime";
    public static final String ID = "earlybedtime";
    public static final Logger LOGGER = LogManager.getLogger((String)"Early Bedtime");

    public EarlyBedtime(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        AllConfigs.register((type, spec) -> modContainer.registerConfig(type, (IConfigSpec)spec));
    }

    public void onInitialize() {
        EntitySleepEvents.ALLOW_SLEEP_TIME.register((player, sleepingPos, vanillaResult) -> {
            Integer allowedSleepTime;
            Level level = player.level();
            if (level.isClientSide()) {
                return InteractionResult.PASS;
            }
            if (level.dimension() != Level.OVERWORLD) {
                return InteractionResult.PASS;
            }
            long time = level.dayTime();
            if (time > (long)(allowedSleepTime = (Integer)AllConfigs.common().sleepTime.get()).intValue() && time < 13000L) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        });
    }

    public void onInitializeClient() {
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        this.onInitialize();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        this.onInitializeClient();
    }
}

