/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.mod.krypton_fnp.shared.network.compression;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import net.minecraft.network.FriendlyByteBuf;
import one.pkg.mod.krypton_fnp.shared.ModConfig;
import one.pkg.mod.krypton_fnp.shared.network.util.SystemInfo;

public class MinecraftCompressEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final VelocityCompressor compressor;
    private final VelocityCompressor jCompressor;
    private int threshold;

    public MinecraftCompressEncoder(int threshold, VelocityCompressor compressor, VelocityCompressor jCompressor) {
        this.threshold = threshold;
        this.compressor = compressor;
        this.jCompressor = jCompressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        FriendlyByteBuf wrappedBuf = new FriendlyByteBuf(out);
        int uncompressed = msg.readableBytes();
        if (uncompressed < this.threshold) {
            wrappedBuf.writeVarInt(0);
            out.writeBytes(msg);
        } else {
            wrappedBuf.writeVarInt(uncompressed);
            VelocityCompressor selectedCompressor = this.getSelectedCompressor(uncompressed);
            ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)ctx.alloc(), (Native)selectedCompressor, (ByteBuf)msg);
            try {
                selectedCompressor.deflate(compatibleIn, out);
            }
            finally {
                compatibleIn.release();
            }
        }
    }

    private VelocityCompressor getSelectedCompressor(int dataSize) {
        return ModConfig.Compression.BlendingMode.isEnabled() || this.jCompressor == null || this.shouldUseNativeCompression(dataSize) ? this.compressor : this.jCompressor;
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) throws Exception {
        if (ModConfig.Compression.BlendingMode.isEnabled()) {
            int initialBufferSize;
            VelocityCompressor targetCompressor;
            int readableBytes = msg.readableBytes();
            if (readableBytes < this.threshold) {
                targetCompressor = this.compressor;
                initialBufferSize = readableBytes + 5;
            } else {
                targetCompressor = this.getSelectedCompressor(readableBytes);
                initialBufferSize = readableBytes < 1024 ? readableBytes + 64 : (readableBytes < 8192 ? Math.max((int)((double)readableBytes * 0.6), 256) + 128 : Math.max((int)((double)readableBytes * 0.4), 512) + 256);
            }
            return MoreByteBufUtils.preferredBuffer((ByteBufAllocator)ctx.alloc(), (Native)targetCompressor, (int)initialBufferSize);
        }
        int initialBufferSize = msg.readableBytes() + 1;
        return MoreByteBufUtils.preferredBuffer((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (int)initialBufferSize);
    }

    private boolean shouldUseNativeCompression(int dataSize) {
        if (SystemInfo.IS_WINDOWS && dataSize < 1024) {
            return false;
        }
        if (dataSize >= 8192) {
            return true;
        }
        return !SystemInfo.IS_WINDOWS || dataSize >= 2048;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.compressor.close();
        if (this.jCompressor != null) {
            this.jCompressor.close();
        }
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

