/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.mod.krypton_fnp.mixin.network.microopt;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.VarInt;
import one.pkg.mod.krypton_fnp.shared.network.util.VarIntUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={VarInt.class})
public class VarIntMixin {
    @Overwrite
    public static int getByteSize(int v) {
        return VarIntUtil.getVarIntLength(v);
    }

    @Overwrite
    public static ByteBuf write(ByteBuf buf, int value) {
        if ((value & 0xFFFFFF80) == 0) {
            buf.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            buf.writeShort((value & 0x7F | 0x80) << 8 | value >>> 7);
        } else if ((value & 0xFFE00000) == 0) {
            buf.writeMedium((value & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | value >>> 14);
        } else if ((value & 0xF0000000) == 0) {
            buf.writeInt((value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | value >>> 21);
        } else {
            buf.writeInt((value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80));
            buf.writeByte(value >>> 28);
        }
        return buf;
    }
}

