/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.capability;

import com.illusivesoulworks.polymorph.api.common.base.IRecipePair;
import com.illusivesoulworks.polymorph.api.common.capability.IBlockEntityRecipeData;
import com.illusivesoulworks.polymorph.common.capability.AbstractRecipeData;
import java.util.TreeSet;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AbstractBlockEntityRecipeData<E extends BlockEntity>
extends AbstractRecipeData<BlockEntity>
implements IBlockEntityRecipeData {
    private boolean wasEmptyBefore = false;

    public AbstractBlockEntityRecipeData(BlockEntity owner) {
        super(owner);
    }

    protected abstract NonNullList<ItemStack> getInput();

    @Override
    public void tick() {
        if (this.getListeners().isEmpty()) {
            return;
        }
        NonNullList<ItemStack> currentInput = this.getInput();
        boolean isEmpty = true;
        for (ItemStack currentStack : currentInput) {
            if (currentStack.isEmpty()) continue;
            isEmpty = false;
            break;
        }
        if (!this.wasEmptyBefore && isEmpty) {
            this.updateRecipesList(new TreeSet<IRecipePair>());
        }
        this.wasEmptyBefore = isEmpty;
    }

    @Override
    public boolean isEmpty() {
        NonNullList<ItemStack> currentInput = this.getInput();
        for (ItemStack currentStack : currentInput) {
            if (currentStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public E getOwner() {
        return (E)((BlockEntity)super.getOwner());
    }
}

