/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import gardensofthedead.block.BlistercrownBlock;
import gardensofthedead.block.CeilingHangingSignBlock;
import gardensofthedead.block.SoulSporeBaseBlock;
import gardensofthedead.block.SoulSporeBlock;
import gardensofthedead.block.SoulblightFungusBlock;
import gardensofthedead.block.SoulblightSproutsBlock;
import gardensofthedead.block.StandingSignBlock;
import gardensofthedead.block.TallBlistercrownBlock;
import gardensofthedead.block.WallHangingSignBlock;
import gardensofthedead.block.WallSignBlock;
import gardensofthedead.block.WhistlecaneBlock;
import gardensofthedead.block.WhistlecaneFenceBlock;
import gardensofthedead.platform.PlatformServices;
import gardensofthedead.registry.ModBlockProperties;
import gardensofthedead.registry.ModBlockSetTypes;
import gardensofthedead.registry.ModWoodTypes;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.PushReaction;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"gardens_of_the_dead", (ResourceKey)Registries.BLOCK);
    public static final RegistrySupplier<SoulSporeBlock> SOUL_SPORE = BLOCKS.register("soul_spore", () -> new SoulSporeBlock(ModBlockProperties.SOUL_SPORE));
    public static final RegistrySupplier<SoulSporeBaseBlock> GLOWING_SOUL_SPORE = BLOCKS.register("glowing_soul_spore", () -> new SoulSporeBaseBlock(ModBlockProperties.GLOWING_SOUL_SPORE));
    public static final RegistrySupplier<Block> SOULBLIGHT_FUNGUS = BLOCKS.register("soulblight_fungus", () -> new SoulblightFungusBlock(ModBlockProperties.SOULBLIGHT_FUNGUS));
    public static final RegistrySupplier<Block> SOULBLIGHT_SPROUTS = BLOCKS.register("soulblight_sprouts", () -> new SoulblightSproutsBlock(ModBlockProperties.SOULBLIGHT_SPROUTS));
    public static final RegistrySupplier<RotatedPillarBlock> STRIPPED_SOULBLIGHT_STEM = ModBlocks.strippedSoulblightStem("stripped_soulblight_stem");
    public static final RegistrySupplier<RotatedPillarBlock> SOULBLIGHT_STEM = ModBlocks.soulblightStem("soulblight_stem", STRIPPED_SOULBLIGHT_STEM);
    public static final RegistrySupplier<RotatedPillarBlock> STRIPPED_SOULBLIGHT_HYPHAE = ModBlocks.strippedSoulblightStem("stripped_soulblight_hyphae");
    public static final RegistrySupplier<RotatedPillarBlock> SOULBLIGHT_HYPHAE = ModBlocks.soulblightStem("soulblight_hyphae", STRIPPED_SOULBLIGHT_HYPHAE);
    public static final RegistrySupplier<Block> BLIGHTWART_BLOCK = ModBlocks.block("blightwart_block", ModBlockProperties.BLIGHTWART_BLOCK);
    public static final RegistrySupplier<Block> BLISTERCROWN = BLOCKS.register("blistercrown", () -> new BlistercrownBlock(ModBlockProperties.BLISTERCROWN));
    public static final RegistrySupplier<DoublePlantBlock> TALL_BLISTERCROWN = BLOCKS.register("tall_blistercrown", () -> new TallBlistercrownBlock(ModBlockProperties.BLISTERCROWN));
    public static final RegistrySupplier<Block> WHISTLECANE = BLOCKS.register("whistlecane", () -> new WhistlecaneBlock(ModBlockProperties.WHISTLECANE));
    public static final RegistrySupplier<FlowerPotBlock> POTTED_SOUL_SPORE = ModBlocks.flowerPot(SOUL_SPORE);
    public static final RegistrySupplier<FlowerPotBlock> POTTED_GLOWING_SOUL_SPORE = ModBlocks.flowerPot(GLOWING_SOUL_SPORE, ModBlockProperties.POTTED_GLOWING_SOUL_SPORE);
    public static final RegistrySupplier<FlowerPotBlock> POTTED_SOULBLIGHT_FUNGUS = ModBlocks.flowerPot(SOULBLIGHT_FUNGUS);
    public static final RegistrySupplier<FlowerPotBlock> POTTED_SOULBLIGHT_SPROUTS = ModBlocks.flowerPot(SOULBLIGHT_SPROUTS);
    public static final RegistrySupplier<FlowerPotBlock> POTTED_BLISTERCROWN = ModBlocks.flowerPot(BLISTERCROWN);
    public static final RegistrySupplier<FlowerPotBlock> POTTED_WHISTLECANE = ModBlocks.flowerPot(WHISTLECANE);
    public static final RegistrySupplier<Block> SOULBLIGHT_PLANKS = ModBlocks.block("soulblight_planks", ModBlockProperties.SOULBLIGHT_PLANKS);
    public static final RegistrySupplier<SlabBlock> SOULBLIGHT_SLAB = BLOCKS.register("soulblight_slab", () -> new SlabBlock(ModBlockProperties.SOULBLIGHT_PLANKS));
    public static final RegistrySupplier<StairBlock> SOULBLIGHT_STAIRS = ModBlocks.stairs("soulblight_stairs", SOULBLIGHT_PLANKS, ModBlockProperties.SOULBLIGHT_PLANKS);
    public static final RegistrySupplier<FenceBlock> SOULBLIGHT_FENCE = BLOCKS.register("soulblight_fence", () -> new FenceBlock(ModBlockProperties.SOULBLIGHT_PLANKS));
    public static final RegistrySupplier<FenceGateBlock> SOULBLIGHT_FENCE_GATE = BLOCKS.register("soulblight_fence_gate", () -> ModBlocks.fenceGate(ModBlockProperties.SOULBLIGHT_PLANKS, ModWoodTypes.SOULBLIGHT));
    public static final RegistrySupplier<ButtonBlock> SOULBLIGHT_BUTTON = BLOCKS.register("soulblight_button", () -> ModBlocks.woodenButton(ModBlockSetTypes.SOULBLIGHT));
    public static final RegistrySupplier<PressurePlateBlock> SOULBLIGHT_PRESSURE_PLATE = BLOCKS.register("soulblight_pressure_plate", () -> ModBlocks.pressurePlate(ModBlockProperties.SOULBLIGHT_PLANKS, ModBlockSetTypes.SOULBLIGHT));
    public static final RegistrySupplier<DoorBlock> SOULBLIGHT_DOOR = BLOCKS.register("soulblight_door", () -> ModBlocks.door(ModBlockProperties.SOULBLIGHT_DOOR, ModBlockSetTypes.SOULBLIGHT));
    public static final RegistrySupplier<TrapDoorBlock> SOULBLIGHT_TRAPDOOR = BLOCKS.register("soulblight_trapdoor", () -> ModBlocks.trapDoor(ModBlockProperties.SOULBLIGHT_TRAPDOOR, ModBlockSetTypes.SOULBLIGHT));
    public static final RegistrySupplier<StandingSignBlock> SOULBLIGHT_SIGN = BLOCKS.register("soulblight_sign", () -> ModBlocks.sign(ModBlockProperties.SOULBLIGHT_PLANKS, ModWoodTypes.SOULBLIGHT));
    public static final RegistrySupplier<WallSignBlock> SOULBLIGHT_WALL_SIGN = BLOCKS.register("soulblight_wall_sign", () -> ModBlocks.wallSign(ModBlockProperties.SOULBLIGHT_PLANKS, SOULBLIGHT_SIGN, ModWoodTypes.SOULBLIGHT));
    public static final RegistrySupplier<CeilingHangingSignBlock> SOULBLIGHT_HANGING_SIGN = BLOCKS.register("soulblight_hanging_sign", () -> ModBlocks.hangingSign(ModBlockProperties.SOULBLIGHT_SIGN, SoundType.NETHER_WOOD_HANGING_SIGN, ModWoodTypes.SOULBLIGHT));
    public static final RegistrySupplier<WallHangingSignBlock> SOULBLIGHT_WALL_HANGING_SIGN = BLOCKS.register("soulblight_wall_hanging_sign", () -> ModBlocks.wallHangingSign(ModBlockProperties.SOULBLIGHT_SIGN, SOULBLIGHT_HANGING_SIGN, SoundType.NETHER_WOOD_HANGING_SIGN, ModWoodTypes.SOULBLIGHT));
    public static final RegistrySupplier<RotatedPillarBlock> WHISTLECANE_BLOCK = BLOCKS.register("whistlecane_block", () -> new RotatedPillarBlock(ModBlockProperties.WHISTLECANE_BLOCK));
    public static final RegistrySupplier<Block> WHISTLECANE_PLANKS = ModBlocks.block("whistlecane_planks", ModBlockProperties.WHISTLECANE_BLOCK);
    public static final RegistrySupplier<SlabBlock> WHISTLECANE_SLAB = BLOCKS.register("whistlecane_slab", () -> new SlabBlock(ModBlockProperties.WHISTLECANE_BLOCK));
    public static final RegistrySupplier<StairBlock> WHISTLECANE_STAIRS = ModBlocks.stairs("whistlecane_stairs", WHISTLECANE_PLANKS, ModBlockProperties.WHISTLECANE_BLOCK);
    public static final RegistrySupplier<WhistlecaneFenceBlock> WHISTLECANE_FENCE = BLOCKS.register("whistlecane_fence", () -> new WhistlecaneFenceBlock(ModBlockProperties.WHISTLECANE_BLOCK));
    public static final RegistrySupplier<FenceGateBlock> WHISTLECANE_FENCE_GATE = BLOCKS.register("whistlecane_fence_gate", () -> ModBlocks.fenceGate(ModBlockProperties.WHISTLECANE_BLOCK, ModWoodTypes.WHISTLECANE));
    public static final RegistrySupplier<ButtonBlock> WHISTLECANE_BUTTON = BLOCKS.register("whistlecane_button", () -> ModBlocks.woodenButton(ModBlockSetTypes.WHISTLECANE));
    public static final RegistrySupplier<PressurePlateBlock> WHISTLECANE_PRESSURE_PLATE = BLOCKS.register("whistlecane_pressure_plate", () -> ModBlocks.pressurePlate(ModBlockProperties.WHISTLECANE_BLOCK, ModBlockSetTypes.WHISTLECANE));
    public static final RegistrySupplier<DoorBlock> WHISTLECANE_DOOR = BLOCKS.register("whistlecane_door", () -> ModBlocks.door(ModBlockProperties.WHISTLECANE_DOOR, ModBlockSetTypes.WHISTLECANE));
    public static final RegistrySupplier<TrapDoorBlock> WHISTLECANE_TRAPDOOR = BLOCKS.register("whistlecane_trapdoor", () -> ModBlocks.trapDoor(ModBlockProperties.WHISTLECANE_TRAPDOOR, ModBlockSetTypes.WHISTLECANE));
    public static final RegistrySupplier<StandingSignBlock> WHISTLECANE_SIGN = BLOCKS.register("whistlecane_sign", () -> ModBlocks.sign(ModBlockProperties.WHISTLECANE_BLOCK, ModWoodTypes.WHISTLECANE));
    public static final RegistrySupplier<WallSignBlock> WHISTLECANE_WALL_SIGN = BLOCKS.register("whistlecane_wall_sign", () -> ModBlocks.wallSign(ModBlockProperties.WHISTLECANE_BLOCK, WHISTLECANE_SIGN, ModWoodTypes.WHISTLECANE));
    public static final RegistrySupplier<CeilingHangingSignBlock> WHISTLECANE_HANGING_SIGN = BLOCKS.register("whistlecane_hanging_sign", () -> ModBlocks.hangingSign(ModBlockProperties.WHISTLECANE_SIGN, SoundType.BAMBOO_WOOD_HANGING_SIGN, ModWoodTypes.WHISTLECANE));
    public static final RegistrySupplier<WallHangingSignBlock> WHISTLECANE_WALL_HANGING_SIGN = BLOCKS.register("whistlecane_wall_hanging_sign", () -> ModBlocks.wallHangingSign(ModBlockProperties.WHISTLECANE_SIGN, WHISTLECANE_HANGING_SIGN, SoundType.BAMBOO_WOOD_HANGING_SIGN, ModWoodTypes.WHISTLECANE));
    public static final RegistrySupplier<Block> WHISTLECANE_MOSAIC = ModBlocks.block("whistlecane_mosaic", ModBlockProperties.WHISTLECANE_BLOCK);
    public static final RegistrySupplier<SlabBlock> WHISTLECANE_MOSAIC_SLAB = BLOCKS.register("whistlecane_mosaic_slab", () -> new SlabBlock(ModBlockProperties.WHISTLECANE_BLOCK));
    public static final RegistrySupplier<StairBlock> WHISTLECANE_MOSAIC_STAIRS = ModBlocks.stairs("whistlecane_mosaic_stairs", WHISTLECANE_MOSAIC, ModBlockProperties.WHISTLECANE_BLOCK);

    private static Supplier<RotatedPillarBlock> createStrippableBlock(BlockBehaviour.Properties properties, RegistrySupplier<? extends Block> strippedBlock) {
        return () -> PlatformServices.platformHelper.createStrippableBlock((Supplier<? extends Block>)strippedBlock, properties);
    }

    private static RegistrySupplier<RotatedPillarBlock> soulblightStem(String name, RegistrySupplier<? extends Block> strippedLogBlock) {
        return BLOCKS.register(name, ModBlocks.createStrippableBlock(ModBlockProperties.SOULBLIGHT_STEM, strippedLogBlock));
    }

    private static RegistrySupplier<RotatedPillarBlock> strippedSoulblightStem(String name) {
        return BLOCKS.register(name, () -> new RotatedPillarBlock(ModBlockProperties.SOULBLIGHT_STEM));
    }

    private static RegistrySupplier<FlowerPotBlock> flowerPot(RegistrySupplier<? extends Block> plant) {
        return ModBlocks.flowerPot(plant, ModBlockProperties.pottedPlant());
    }

    private static RegistrySupplier<FlowerPotBlock> flowerPot(RegistrySupplier<? extends Block> plant, BlockBehaviour.Properties properties) {
        return BLOCKS.register("potted_" + plant.getId().getPath(), () -> PlatformServices.platformHelper.createFlowerPot(plant, properties));
    }

    private static RegistrySupplier<StairBlock> stairs(String name, Supplier<? extends Block> baseBlock, BlockBehaviour.Properties properties) {
        return BLOCKS.register(name, () -> new StairBlock(((Block)baseBlock.get()).defaultBlockState(), properties));
    }

    private static RegistrySupplier<Block> block(String name, BlockBehaviour.Properties properties) {
        return BLOCKS.register(name, () -> new Block(properties));
    }

    private static ButtonBlock woodenButton(BlockSetType blockSetType) {
        int ticksToStayPressed = 30;
        return ModBlocks.button(ticksToStayPressed, blockSetType);
    }

    private static ButtonBlock button(int ticksToStayPressed, BlockSetType blockSetType) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY).sound(blockSetType.soundType());
        return new ButtonBlock(blockSetType, ticksToStayPressed, properties);
    }

    private static PressurePlateBlock pressurePlate(BlockBehaviour.Properties baseProperties, BlockSetType blockSetType) {
        BlockBehaviour.Properties properties = ModBlockProperties.copy(baseProperties).noCollission().strength(0.5f);
        return new PressurePlateBlock(blockSetType, properties);
    }

    private static FenceGateBlock fenceGate(BlockBehaviour.Properties baseProperties, WoodType woodType) {
        BlockBehaviour.Properties properties = ModBlockProperties.copy(baseProperties).strength(2.0f, 3.0f);
        return new FenceGateBlock(woodType, properties);
    }

    private static DoorBlock door(BlockBehaviour.Properties baseProperties, BlockSetType blockSetType) {
        BlockBehaviour.Properties properties = ModBlockProperties.copy(baseProperties).strength(3.0f).noOcclusion();
        return new DoorBlock(blockSetType, properties);
    }

    private static TrapDoorBlock trapDoor(BlockBehaviour.Properties baseProperties, BlockSetType blockSetType) {
        BlockBehaviour.Properties properties = ModBlockProperties.copy(baseProperties).strength(3.0f).noOcclusion().isValidSpawn(ModBlockProperties::never);
        return new TrapDoorBlock(blockSetType, properties);
    }

    private static StandingSignBlock sign(BlockBehaviour.Properties baseProperties, WoodType woodType) {
        BlockBehaviour.Properties properties = ModBlockProperties.copy(baseProperties).strength(1.0f).noCollission();
        return new StandingSignBlock(woodType, properties);
    }

    private static WallSignBlock wallSign(BlockBehaviour.Properties baseProperties, RegistrySupplier<?> signBlock, WoodType woodType) {
        BlockBehaviour.Properties properties = ModBlockProperties.copyWithLoot(baseProperties, signBlock.getId()).strength(1.0f).noCollission();
        return new WallSignBlock(woodType, properties);
    }

    private static CeilingHangingSignBlock hangingSign(BlockBehaviour.Properties baseProperties, SoundType soundType, WoodType woodType) {
        BlockBehaviour.Properties properties = ModBlockProperties.copy(baseProperties).sound(soundType).strength(1.0f).noCollission();
        return new CeilingHangingSignBlock(woodType, properties);
    }

    private static WallHangingSignBlock wallHangingSign(BlockBehaviour.Properties baseProperties, RegistrySupplier<?> signBlock, SoundType soundType, WoodType woodType) {
        BlockBehaviour.Properties properties = ModBlockProperties.copyWithLoot(baseProperties, signBlock.getId()).sound(soundType).strength(1.0f).noCollission();
        return new WallHangingSignBlock(woodType, properties);
    }
}

