/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.neoforge.datagen;

import gardensofthedead.GardensOfTheDead;
import gardensofthedead.neoforge.datagen.ConfiguredFeatureProvider;
import gardensofthedead.placementmodifier.CountOnEveryCeilingPlacement;
import gardensofthedead.registry.ModBlocks;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class PlacedFeatureProvider {
    private static final Map<ResourceKey<PlacedFeature>, ResourceKey<ConfiguredFeature<?, ?>>> CONFIGURED_FEATURES = new HashMap();
    private static final Map<ResourceKey<PlacedFeature>, Supplier<List<PlacementModifier>>> PLACEMENT_MODIFIERS = new HashMap<ResourceKey<PlacedFeature>, Supplier<List<PlacementModifier>>>();
    public static final ResourceKey<PlacedFeature> SOULBLIGHT_FUNGI = PlacedFeatureProvider.register("soulblight_fungi", ConfiguredFeatureProvider.SOULBLIGHT_FUNGUS, new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)3), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.not((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.LAVA}))), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Vec3i.ZERO.below(), (Block[])new Block[]{Blocks.SOUL_SOIL})), BiomeFilter.biome()});
    public static final ResourceKey<PlacedFeature> SOULBLIGHT_FOREST_VEGETATION = PlacedFeatureProvider.register("soulblight_forest_vegetation", ConfiguredFeatureProvider.SOULBLIGHT_FOREST_VEGETATION, new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)2), BiomeFilter.biome()});
    public static final ResourceKey<PlacedFeature> SHORT_STANDING_SOUL_SPORE_PATCH = PlacedFeatureProvider.register("short_standing_soul_spore_patch", ConfiguredFeatureProvider.SHORT_STANDING_SOUL_SPORE_PATCH, new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)4), BiomeFilter.biome()});
    public static final ResourceKey<PlacedFeature> LONG_STANDING_SOUL_SPORE_PATCH = PlacedFeatureProvider.register("long_standing_soul_spore_patch", ConfiguredFeatureProvider.LONG_STANDING_SOUL_SPORE_PATCH, new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)12), BiomeFilter.biome()});
    public static final ResourceKey<PlacedFeature> SHORT_HANGING_SOUL_SPORE_PATCH = PlacedFeatureProvider.register("short_hanging_soul_spore_patch", ConfiguredFeatureProvider.SHORT_HANGING_SOUL_SPORE_PATCH, new PlacementModifier[]{CountOnEveryCeilingPlacement.of(4), BiomeFilter.biome()});
    public static final ResourceKey<PlacedFeature> LONG_HANGING_SOUL_SPORE_PATCH = PlacedFeatureProvider.register("long_hanging_soul_spore_patch", ConfiguredFeatureProvider.LONG_HANGING_SOUL_SPORE_PATCH, new PlacementModifier[]{CountOnEveryCeilingPlacement.of(8), BiomeFilter.biome()});
    public static final ResourceKey<PlacedFeature> NOISY_CRIMSON_FUNGI = PlacedFeatureProvider.register("noisy_crimson_fungi", TreeFeatures.CRIMSON_FUNGUS, new PlacementModifier[]{NoiseBasedCountPlacement.of((int)6, (double)180.0, (double)0.0), CountOnEveryLayerPlacement.of((int)1), BiomeFilter.biome()});
    public static final ResourceKey<PlacedFeature> DENSE_WEEPING_VINES = PlacedFeatureProvider.register("dense_weeping_vines", NetherFeatures.WEEPING_VINES, new PlacementModifier[]{CountPlacement.of((int)40), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BiomeFilter.biome()});
    public static final ResourceKey<PlacedFeature> WHISTLECANE_COLUMN = PlacedFeatureProvider.register("whistlecane_column", ConfiguredFeatureProvider.WHISTLECANE_COLUMN, () -> List.of(CountOnEveryLayerPlacement.of((int)20), PlacementUtils.filteredByBlockSurvival((Block)((Block)ModBlocks.WHISTLECANE.get())), BiomeFilter.biome()));
    public static final ResourceKey<PlacedFeature> WHISTLING_WOODS_VEGETATION = PlacedFeatureProvider.register("whistling_woods_vegetation", ConfiguredFeatureProvider.WHISTLING_WOODS_VEGETATION, new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)10), BiomeFilter.biome()});
    public static final ResourceKey<PlacedFeature> TALL_BLISTERCROWN_PATCH = PlacedFeatureProvider.register("tall_blistercrown_patch", ConfiguredFeatureProvider.TALL_BLISTERCROWN_PATCH, new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)1), BiomeFilter.biome()});
    public static final ResourceKey<PlacedFeature> NETHER_WART_BLOCK_PILE = PlacedFeatureProvider.register("nether_wart_block_pile", ConfiguredFeatureProvider.NETHER_WART_BLOCK_PILE, new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)1), RarityFilter.onAverageOnceEvery((int)2), BiomeFilter.biome()});

    public static void create(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        for (ResourceKey<PlacedFeature> key : PLACEMENT_MODIFIERS.keySet()) {
            Holder.Reference configuredFeature = configuredFeatures.getOrThrow(CONFIGURED_FEATURES.get(key));
            List<PlacementModifier> modifiers = PLACEMENT_MODIFIERS.get(key).get();
            PlacedFeature placedFeature = new PlacedFeature((Holder)configuredFeature, modifiers);
            context.register(key, (Object)placedFeature);
        }
    }

    private static ResourceKey<PlacedFeature> register(String name, ResourceKey<ConfiguredFeature<?, ?>> configuredFeature, PlacementModifier ... modifiers) {
        return PlacedFeatureProvider.register(name, configuredFeature, () -> List.of(modifiers));
    }

    private static ResourceKey<PlacedFeature> register(String name, ResourceKey<ConfiguredFeature<?, ?>> configuredFeature, Supplier<List<PlacementModifier>> modifiers) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)GardensOfTheDead.id(name));
        CONFIGURED_FEATURES.put((ResourceKey<PlacedFeature>)key, configuredFeature);
        PLACEMENT_MODIFIERS.put((ResourceKey<PlacedFeature>)key, modifiers);
        return key;
    }
}

