/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.feature;

import com.mojang.serialization.Codec;
import gardensofthedead.block.SoulSporeBaseBlock;
import gardensofthedead.block.SoulSporeBlock;
import gardensofthedead.feature.configuration.SoulSporeColumnConfiguration;
import gardensofthedead.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class SoulSporeColumnFeature
extends Feature<SoulSporeColumnConfiguration> {
    public SoulSporeColumnFeature(Codec<SoulSporeColumnConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SoulSporeColumnConfiguration> context) {
        WorldGenLevel level = context.level();
        SoulSporeColumnConfiguration config = (SoulSporeColumnConfiguration)context.config();
        BlockPos origin = context.origin();
        if (!SoulSporeColumnFeature.isValidPlacementLocation((LevelAccessor)level, origin, config)) {
            return false;
        }
        Direction direction = config.direction();
        RandomSource randomSource = context.random();
        int length = config.length().sample(randomSource);
        float glowingChance = config.glowingChance();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos().set((Vec3i)origin);
        SoulSporeColumnFeature.placeSoulSporeColumn((LevelAccessor)level, randomSource, pos, length, direction, glowingChance);
        return true;
    }

    public static void placeSoulSporeColumn(LevelAccessor level, RandomSource randomSource, BlockPos.MutableBlockPos pos, int length, Direction direction, float glowingChance) {
        for (int y = 1; y <= length; ++y) {
            if (level.isEmptyBlock((BlockPos)pos)) {
                if (y == length || !level.isEmptyBlock(pos.relative(direction))) {
                    BlockState topState = randomSource.nextFloat() < glowingChance && y > 1 ? ((SoulSporeBaseBlock)((Object)ModBlocks.GLOWING_SOUL_SPORE.get())).defaultBlockState() : (BlockState)((SoulSporeBlock)((Object)ModBlocks.SOUL_SPORE.get())).defaultBlockState().setValue((Property)SoulSporeBlock.GROWING, (Comparable)Boolean.valueOf(false));
                    level.setBlock((BlockPos)pos, (BlockState)topState.setValue((Property)SoulSporeBaseBlock.DIRECTION, (Comparable)direction), 2);
                    break;
                }
                BlockState state = (BlockState)((BlockState)((BlockState)((SoulSporeBlock)((Object)ModBlocks.SOUL_SPORE.get())).defaultBlockState().setValue((Property)SoulSporeBlock.TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)SoulSporeBaseBlock.DIRECTION, (Comparable)direction)).setValue((Property)SoulSporeBlock.GROWING, (Comparable)Boolean.valueOf(false));
                level.setBlock((BlockPos)pos, state, 2);
            }
            pos.move(direction);
        }
    }

    private static boolean isValidPlacementLocation(LevelAccessor level, BlockPos pos, SoulSporeColumnConfiguration configuration) {
        if (level.isEmptyBlock(pos)) {
            BlockState supportingState = level.getBlockState(pos.relative(configuration.direction().getOpposite()));
            return supportingState.is(Blocks.SOUL_SAND) || supportingState.is(Blocks.SOUL_SOIL);
        }
        return false;
    }
}

