/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.treasure_reforging.recipe.recipes;

import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.treasure_reforging.item.ReforgingItems;
import com.aetherteam.treasure_reforging.recipe.TreasureReforgingRecipeSerializers;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PhoenixArmorRecipe
extends CustomRecipe {
    private final Map<Item, Item> conversions = new HashMap<Item, Item>(Map.of((Item)AetherItems.OBSIDIAN_BOOTS.get(), (Item)AetherItems.PHOENIX_BOOTS.get(), (Item)AetherItems.OBSIDIAN_LEGGINGS.get(), (Item)AetherItems.PHOENIX_LEGGINGS.get(), (Item)AetherItems.OBSIDIAN_CHESTPLATE.get(), (Item)AetherItems.PHOENIX_CHESTPLATE.get(), (Item)AetherItems.OBSIDIAN_HELMET.get(), (Item)AetherItems.PHOENIX_HELMET.get(), (Item)AetherItems.OBSIDIAN_GLOVES.get(), (Item)AetherItems.PHOENIX_GLOVES.get()));
    private static final Ingredient SHARD_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ReforgingItems.PYRAL_SHARD.get()});

    public PhoenixArmorRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        int shardCount = 0;
        int equipmentCount = 0;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack item = craftingInput.getItem(i);
            if (item.isEmpty()) continue;
            if (this.conversions.containsKey(item.getItem())) {
                ++equipmentCount;
                continue;
            }
            if (!SHARD_INGREDIENT.test(item)) continue;
            ++shardCount;
        }
        return shardCount == 4 && equipmentCount == 1;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        ItemStack result = ItemStack.EMPTY;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack item = craftingInput.getItem(i);
            if (item.isEmpty() || !this.conversions.containsKey(item.getItem())) continue;
            result = new ItemStack((Holder)this.conversions.get(item.getItem()).builtInRegistryHolder(), 1, item.getComponentsPatch());
        }
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TreasureReforgingRecipeSerializers.PHOENIX_ARMOR.get();
    }
}

