/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.treasure_reforging.data.resources.registries;

import com.aetherteam.treasure_reforging.item.ReforgingItems;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class ReforgingTrimMaterials {
    public static final ResourceKey<TrimMaterial> NEPTUNE = ReforgingTrimMaterials.createKey("neptune");
    public static final ResourceKey<TrimMaterial> VALKYRIE = ReforgingTrimMaterials.createKey("valkyrie");
    public static final ResourceKey<TrimMaterial> PHOENIX = ReforgingTrimMaterials.createKey("phoenix");

    private static ResourceKey<TrimMaterial> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aether_treasure_reforging", (String)name));
    }

    public static void bootstrap(BootstrapContext<TrimMaterial> context) {
        ReforgingTrimMaterials.register(context, NEPTUNE, (Item)ReforgingItems.NEPTUNE_MESH.get(), Style.EMPTY.withColor(4091864), 0.9f);
        ReforgingTrimMaterials.register(context, VALKYRIE, ((Item)ReforgingItems.VALKYRUM_INGOT.get()).asItem(), Style.EMPTY.withColor(13886178), 0.2f);
        ReforgingTrimMaterials.register(context, PHOENIX, ((Item)ReforgingItems.PYRAL_INGOT.get()).asItem(), Style.EMPTY.withColor(16750107), 0.5f);
    }

    private static void register(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> materialKey, Item ingredient, Style style, float itemModelIndex) {
        ReforgingTrimMaterials.register(context, materialKey, ingredient, style, itemModelIndex, Map.of());
    }

    private static void register(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> materialKey, Item ingredient, Style style, float itemModelIndex, Map<Holder<ArmorMaterial>, String> overrideArmorMaterials) {
        TrimMaterial trimMaterial = TrimMaterial.create((String)materialKey.location().getPath(), (Item)ingredient, (float)itemModelIndex, (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_material", (ResourceLocation)materialKey.location())).withStyle(style), overrideArmorMaterials);
        context.register(materialKey, (Object)trimMaterial);
    }
}

