/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.treasure_reforging.block;

import com.aetherteam.aether.block.miscellaneous.FacingPillarBlock;
import com.aetherteam.treasure_reforging.item.ReforgingItems;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ReforgingBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"aether_treasure_reforging");
    public static final DeferredBlock<FacingPillarBlock> VALKYRUM_BLOCK = ReforgingBlocks.register("valkyrum_block", () -> new FacingPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.CHIME).strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.METAL)));
    public static final DeferredBlock<Block> PYRAL_BLOCK = ReforgingBlocks.register("pyral_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.DIDGERIDOO).strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.METAL)));

    private static <T extends Block> DeferredBlock<T> baseRegister(String name, Supplier<? extends T> block, Function<DeferredBlock<T>, Supplier<? extends Item>> item) {
        DeferredBlock register = BLOCKS.register(name, block);
        ReforgingItems.ITEMS.register(name, item.apply(register));
        return register;
    }

    private static <B extends Block> DeferredBlock<B> register(String name, Supplier<? extends Block> block) {
        return ReforgingBlocks.baseRegister(name, block, ReforgingBlocks::registerBlockItem);
    }

    private static <B extends Block> Supplier<BlockItem> registerBlockItem(DeferredBlock<B> blockRegistryObject) {
        return () -> {
            Block block = Objects.requireNonNull((Block)blockRegistryObject.get());
            if (block == PYRAL_BLOCK.get()) {
                return new BlockItem(block, new Item.Properties().fireResistant());
            }
            return new BlockItem(block, new Item.Properties());
        };
    }
}

