/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.enhanced_extinguishing.data.providers;

import com.aetherteam.enhanced_extinguishing.block.ExtinguishedWallTorchBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class ExtinguishingBlockStateProvider
extends BlockStateProvider {
    public ExtinguishingBlockStateProvider(PackOutput output, String id, ExistingFileHelper helper) {
        super(output, id, helper);
    }

    public String name(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    public ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    public void torch(Block block) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/template_torch"))).texture("torch", this.texture(this.name(block)))).renderType(ResourceLocation.withDefaultNamespace((String)"cutout"));
        this.simpleBlock(block, (ModelFile)model);
    }

    public void wallTorch(Block block, Block torch) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/template_torch_wall"))).texture("torch", this.texture(this.name(torch)))).renderType(ResourceLocation.withDefaultNamespace((String)"cutout"));
        this.getVariantBuilder(block).partialState().with((Property)ExtinguishedWallTorchBlock.FACING, (Comparable)Direction.EAST).addModels(ConfiguredModel.builder().modelFile((ModelFile)model).build()).partialState().with((Property)ExtinguishedWallTorchBlock.FACING, (Comparable)Direction.NORTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(270).build()).partialState().with((Property)ExtinguishedWallTorchBlock.FACING, (Comparable)Direction.SOUTH).addModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(90).build()).partialState().with((Property)ExtinguishedWallTorchBlock.FACING, (Comparable)Direction.WEST).addModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(180).build());
    }

    public void lantern(Block block, String hangingName) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/template_lantern"))).texture("lantern", this.texture(this.name(block)))).renderType(ResourceLocation.withDefaultNamespace((String)"cutout"));
        ModelBuilder hanging = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(hangingName, this.mcLoc("block/template_hanging_lantern"))).texture("lantern", this.texture(this.name(block)))).renderType(ResourceLocation.withDefaultNamespace((String)"cutout"));
        this.getVariantBuilder(block).partialState().with((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.builder().modelFile((ModelFile)model).build()).partialState().with((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.builder().modelFile((ModelFile)hanging).build());
    }
}

