/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.enhanced_extinguishing;

import com.aetherteam.enhanced_extinguishing.block.ExtinguishingBlocks;
import com.aetherteam.enhanced_extinguishing.data.generators.ExtinguishingBlockStateData;
import com.aetherteam.enhanced_extinguishing.data.generators.ExtinguishingLanguageData;
import com.aetherteam.enhanced_extinguishing.data.generators.ExtinguishingRecipeData;
import com.aetherteam.enhanced_extinguishing.data.generators.tags.ExtinguishingBlockTagData;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.DetectedVersion;
import net.minecraft.SharedConstants;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.flag.FeatureFlagSet;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="aether_enhanced_extinguishing")
public class EnhancedExtinguishing {
    public static final String MODID = "aether_enhanced_extinguishing";
    private static final Logger LOGGER = LogUtils.getLogger();

    public EnhancedExtinguishing(IEventBus bus, Dist dist) {
        DeferredRegister[] registers;
        for (DeferredRegister register : registers = new DeferredRegister[]{ExtinguishingBlocks.BLOCKS}) {
            register.register(bus);
        }
        bus.addListener(this::dataSetup);
        bus.addListener(this::packSetup);
    }

    public void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(event.includeClient(), (DataProvider)new ExtinguishingBlockStateData(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ExtinguishingLanguageData(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ExtinguishingRecipeData(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ExtinguishingBlockTagData(packOutput, lookupProvider, fileHelper));
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(packOutput).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.translatable((String)"pack.aether_enhanced_extinguishing.mod.description"), DetectedVersion.BUILT_IN.getPackVersion(PackType.SERVER_DATA), Optional.of(new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE))))));
    }

    public void packSetup(AddPackFindersEvent event) {
        this.setupRecipeOverridePack(event);
    }

    private void setupRecipeOverridePack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/recipe_override"});
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.literal((String)""), SharedConstants.getCurrentVersion().getPackVersion(PackType.SERVER_DATA));
            event.addRepositorySource(source -> source.accept(new Pack(new PackLocationInfo("builtin/extinguishing_recipe_override", (Component)Component.literal((String)""), PackSource.BUILT_IN, Optional.empty()), (Pack.ResourcesSupplier)new PathPackResources.PathResourcesSupplier(resourcePath), new Pack.Metadata(metadata.description(), PackCompatibility.COMPATIBLE, FeatureFlagSet.of(), List.of(), true), new PackSelectionConfig(true, Pack.Position.TOP, false))));
        }
    }
}

