/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.config;

import com.mojang.datafixers.util.Pair;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractButtonListScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class LocaleConfig
extends ConfigValue<String> {
    public static final Color4I COLOR = Color4I.rgb((int)16755273);

    public void onClicked(Widget clickedWidget, MouseButton button, ConfigCallback callback) {
        LocaleSelectorScreen gui = new LocaleSelectorScreen(callback);
        gui.setTitle((Component)Component.translatable((String)"ftbquests.xlate.editing_locale"));
        gui.showBottomPanel(false);
        gui.setHasSearchBox(true);
        gui.openGui();
    }

    public Color4I getColor(@Nullable String v) {
        return COLOR;
    }

    public Component getStringForGUI(@Nullable String v) {
        return v == null ? NULL_TEXT : Component.literal((String)("\"" + v + "\""));
    }

    private class LocaleSelectorScreen
    extends AbstractButtonListScreen {
        private final ConfigCallback callback;
        private final List<Pair<String, Component>> entries = new ArrayList<Pair<String, Component>>();
        private final int widest;

        public LocaleSelectorScreen(ConfigCallback callback) {
            this.callback = callback;
            MutableInt widestM = new MutableInt(0);
            this.entries.add((Pair<String, Component>)new Pair((Object)"", (Object)Component.translatable((String)"ftbquests.gui.use_default_lang").withStyle(ChatFormatting.ITALIC)));
            Minecraft.getInstance().getLanguageManager().getLanguages().forEach((lang, info) -> {
                MutableComponent c = Component.literal((String)("[" + lang + "] ")).withStyle(ChatFormatting.YELLOW).append((Component)info.toComponent().copy().withStyle(ChatFormatting.WHITE));
                this.entries.add((Pair<String, Component>)new Pair(lang, (Object)c));
                widestM.setValue(Math.max(widestM.toInteger(), this.getTheme().getStringWidth((FormattedText)c)));
            });
            this.widest = widestM.intValue();
        }

        public boolean onInit() {
            this.setWidth(this.widest + 25);
            this.setHeight(this.getScreen().getGuiScaledHeight() * 4 / 5);
            return true;
        }

        public void addButtons(Panel panel) {
            this.entries.forEach(entry -> panel.add((Widget)new SimpleTextButton(panel, (Component)entry.getSecond(), (Icon)Color4I.empty(), (Pair)entry){
                final /* synthetic */ Pair val$entry;
                {
                    this.val$entry = pair;
                    super(panel, txt, icon);
                }

                public void onClicked(MouseButton button) {
                    this.playClickSound();
                    boolean changed = LocaleConfig.this.setCurrentValue((String)this.val$entry.getFirst());
                    LocaleSelectorScreen.this.callback.save(changed);
                }
            }));
        }

        protected void doCancel() {
            this.callback.save(false);
        }

        protected void doAccept() {
            this.callback.save(true);
        }
    }
}

