/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.veinmining;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class VeinMiningPlayers {
    private static final long DIFF = 20L;
    private static final Map<UUID, Long> ACTIVATED_MINERS = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Long> CURRENT_MINERS = new ConcurrentHashMap<UUID, Long>();
    private static final Map<Level, Map<BlockPos, BlockPos>> MINING_BLOCKS = new ConcurrentHashMap<Level, Map<BlockPos, BlockPos>>();

    public static void validate(long worldTime) {
        Iterator<Map.Entry<UUID, Long>> entries = ACTIVATED_MINERS.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<UUID, Long> entry = entries.next();
            long lastTime = entry.getValue();
            if (worldTime - lastTime <= 20L && lastTime <= worldTime) continue;
            entries.remove();
        }
    }

    public static boolean canStartVeinMining(Player player) {
        return ACTIVATED_MINERS.containsKey(player.getUUID());
    }

    public static void activateVeinMining(Player player, long time) {
        ACTIVATED_MINERS.put(player.getUUID(), time);
    }

    public static void deactivateVeinMining(Player player) {
        ACTIVATED_MINERS.remove(player.getUUID());
    }

    public static boolean isVeinMining(Player player) {
        return CURRENT_MINERS.containsKey(player.getUUID());
    }

    public static void startVeinMining(Player player) {
        CURRENT_MINERS.put(player.getUUID(), player.level().getGameTime());
    }

    public static void stopVeinMining(Player player) {
        CURRENT_MINERS.remove(player.getUUID());
    }

    public static void addMiningBlock(Level level, BlockPos pos, BlockPos spawnPos) {
        MINING_BLOCKS.computeIfAbsent(level, k -> new HashMap()).put(pos, spawnPos);
    }

    public static void removeMiningBlock(Level level, BlockPos pos) {
        Map<BlockPos, BlockPos> map = MINING_BLOCKS.get(level);
        if (map != null) {
            map.remove(pos);
        }
    }

    public static Optional<BlockPos> getNewSpawnPosForDrop(Level level, BlockPos pos) {
        Map<BlockPos, BlockPos> map = MINING_BLOCKS.get(level);
        if (map != null) {
            return Optional.ofNullable(map.get(pos));
        }
        return Optional.empty();
    }
}

