/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common;

import com.illusivesoulworks.veinmining.common.data.BlockGroupsResourceListener;
import com.illusivesoulworks.veinmining.common.veinmining.VeinMiningEvents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class NeoForgeCommonEventsListener {
    @SubscribeEvent
    public void levelTick(LevelTickEvent.Post evt) {
        VeinMiningEvents.tick(evt.getLevel());
    }

    @SubscribeEvent
    public void reload(AddReloadListenerEvent evt) {
        BlockGroupsResourceListener.INSTANCE = new BlockGroupsResourceListener();
        evt.addListener((PreparableReloadListener)BlockGroupsResourceListener.INSTANCE);
    }

    @SubscribeEvent
    public void serverStarted(ServerStartedEvent evt) {
        VeinMiningEvents.reloadDatapack();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void blockBreak(BlockEvent.BreakEvent evt) {
        Player player = evt.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            VeinMiningEvents.blockBreak(player2, evt.getPos(), evt.getState());
        }
    }

    @SubscribeEvent
    public void toolEquip(LivingEquipmentChangeEvent evt) {
        VeinMiningEvents.toolEquip(evt.getTo(), evt.getFrom(), evt.getSlot(), evt.getEntity());
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent evt) {
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            VeinMiningEvents.playerLoggedOut(player2);
        }
    }
}

