/*
 * Decompiled with CFR 0.152.
 */
package com.clientcrafting.mixin;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CraftingMenu.class})
public class CraftingMixin {
    @Unique
    private static boolean queued = false;
    @Shadow
    @Final
    @Mutable
    private ContainerLevelAccess access;
    @Shadow
    @Final
    private Player player;

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="RETURN")})
    private void onInitContainerAccess(int p_39356_, Inventory p_39357_, ContainerLevelAccess containerLevelAccess, CallbackInfo ci) {
        if (containerLevelAccess == ContainerLevelAccess.NULL) {
            this.access = ContainerLevelAccess.create((Level)this.player.level(), (BlockPos)this.player.blockPosition());
        }
    }

    @Inject(method={"slotChangedCraftingGrid"}, at={@At(value="RETURN")})
    private static void showClientRecipe(AbstractContainerMenu menu, Level level, Player player, CraftingContainer container, ResultContainer resultContainer, @Nullable RecipeHolder<CraftingRecipe> recipeHolder, CallbackInfo ci) {
        if (level.isClientSide() && !queued) {
            queued = true;
            Minecraft.getInstance().submit(() -> {
                ItemStack resultItem;
                RecipeHolder craftingrecipe;
                ItemStack itemStack = ItemStack.EMPTY;
                Optional optional = level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)container.asCraftInput(), level, recipeHolder);
                if (optional.isPresent() && CraftingMixin.setRecipeUsedClientCheck(level, (LocalPlayer)player, (RecipeHolder<CraftingRecipe>)(craftingrecipe = (RecipeHolder)optional.get()), resultContainer) && (resultItem = ((CraftingRecipe)craftingrecipe.value()).assemble((RecipeInput)container.asCraftInput(), (HolderLookup.Provider)level.registryAccess())).isItemEnabled(level.enabledFeatures())) {
                    itemStack = resultItem;
                }
                resultContainer.setItem(0, itemStack);
                menu.setRemoteSlot(0, itemStack);
                queued = false;
            });
        }
    }

    @Unique
    private static boolean setRecipeUsedClientCheck(Level level, LocalPlayer player, RecipeHolder<CraftingRecipe> craftingrecipe, ResultContainer resultContainer) {
        if (!((CraftingRecipe)craftingrecipe.value()).isSpecial() && level.getGameRules().getBoolean(GameRules.RULE_LIMITED_CRAFTING) && !player.getRecipeBook().contains(craftingrecipe)) {
            return false;
        }
        resultContainer.setRecipeUsed(craftingrecipe);
        return true;
    }
}

