/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.range;

import com.teamresourceful.resourcefulconfig.api.annotations.ConfigOption;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigValueEntry;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryData;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryType;
import com.teamresourceful.resourcefulconfig.api.types.options.Option;
import com.teamresourceful.resourcefulconfig.client.components.options.range.OptionRange;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public record WholeOptionRange(LongConsumer setter, LongSupplier getter, long min, long max, long step) implements OptionRange
{
    private WholeOptionRange(LongConsumer setter, LongSupplier getter, double min, double max, long step) {
        this(setter, getter, (long)min, (long)max, step);
    }

    public static WholeOptionRange of(ResourcefulConfigValueEntry entry) {
        return switch (entry.type()) {
            case EntryType.BYTE -> WholeOptionRange.ofByte(entry);
            case EntryType.SHORT -> WholeOptionRange.ofShort(entry);
            case EntryType.INTEGER -> WholeOptionRange.ofInteger(entry);
            case EntryType.LONG -> WholeOptionRange.ofLong(entry);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)entry.type()));
        };
    }

    private static WholeOptionRange ofByte(ResourcefulConfigValueEntry entry) {
        LongConsumer setter = value -> entry.setByte((byte)value);
        LongSupplier getter = entry::getByte;
        EntryData options = entry.options();
        if (options.hasOption(Option.RANGE)) {
            ConfigOption.Range range = options.getOption(Option.RANGE);
            return new WholeOptionRange(setter, getter, range.min(), range.max(), 1L);
        }
        return new WholeOptionRange(setter, getter, -128L, 127L, 0L);
    }

    private static WholeOptionRange ofShort(ResourcefulConfigValueEntry entry) {
        LongConsumer setter = value -> entry.setShort((short)value);
        LongSupplier getter = entry::getShort;
        EntryData options = entry.options();
        if (options.hasOption(Option.RANGE)) {
            ConfigOption.Range range = options.getOption(Option.RANGE);
            return new WholeOptionRange(setter, getter, range.min(), range.max(), 1L);
        }
        return new WholeOptionRange(setter, getter, -32768L, 32767L, 0L);
    }

    private static WholeOptionRange ofInteger(ResourcefulConfigValueEntry entry) {
        LongConsumer setter = value -> entry.setInt((int)value);
        LongSupplier getter = entry::getInt;
        EntryData options = entry.options();
        if (options.hasOption(Option.RANGE)) {
            ConfigOption.Range range = options.getOption(Option.RANGE);
            return new WholeOptionRange(setter, getter, range.min(), range.max(), 1L);
        }
        return new WholeOptionRange(setter, getter, Integer.MIN_VALUE, Integer.MAX_VALUE, 0L);
    }

    private static WholeOptionRange ofLong(ResourcefulConfigValueEntry entry) {
        LongConsumer setter = entry::setLong;
        LongSupplier getter = entry::getLong;
        EntryData options = entry.options();
        if (options.hasOption(Option.RANGE)) {
            ConfigOption.Range range = options.getOption(Option.RANGE);
            return new WholeOptionRange(setter, getter, range.min(), range.max(), 1L);
        }
        return new WholeOptionRange(setter, getter, Long.MIN_VALUE, Long.MAX_VALUE, 0L);
    }

    @Override
    public Component toComponent() {
        return Component.literal((String)String.valueOf(this.getter.getAsLong()));
    }

    @Override
    public Component minComponent() {
        return Component.literal((String)String.valueOf(this.min));
    }

    @Override
    public Component maxComponent() {
        return Component.literal((String)String.valueOf(this.max));
    }

    @Override
    public void setPercent(double value) {
        this.setter.accept((long)Mth.clampedLerp((double)this.min, (double)this.max, (double)value));
    }

    @Override
    public double getPercent() {
        return (double)(this.getter.getAsLong() - this.min) / (double)(this.max - this.min);
    }

    @Override
    public double getStepPercent() {
        return (double)this.step / (double)(this.max - this.min);
    }

    @Override
    public boolean hasRange() {
        return this.step != 0L;
    }
}

