/*
 * Decompiled with CFR 0.152.
 */
package toni.despawntweaks.mixins;

import java.util.Collections;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import toni.despawntweaks.foundation.DataComponentRegistry;
import toni.despawntweaks.foundation.IDespawnTweaksMob;
import toni.despawntweaks.foundation.config.AllConfigs;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity
implements IDespawnTweaksMob {
    @Shadow
    private boolean persistenceRequired;
    @Unique
    private static final EquipmentSlot[] EQUIPMENT_SLOTS = EquipmentSlot.values();
    @Unique
    @Nullable
    private Set<Structure> despawnTweaker$spawnStructures = null;

    @Shadow
    @NotNull
    public abstract ItemStack getItemBySlot(@NotNull EquipmentSlot var1);

    protected MobMixin(EntityType<? extends LivingEntity> arg, Level arg2) {
        super(arg, arg2);
    }

    @Inject(method={"setItemSlotAndDropWhenKilled(Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="TAIL")})
    private void onSetItemSlotAndDropWhenKilled(EquipmentSlot arg, ItemStack itemStack, CallbackInfo ci) {
        if (((Boolean)AllConfigs.common().ENABLE_LET_ME_DESPAWN_OPTIMIZATION.get()).booleanValue()) {
            ItemStack stack = this.getItemBySlot(arg);
            stack.set(DataComponentRegistry.get(), (Object)true);
            this.addTag("despawnTweaker.pickedItems");
            this.persistenceRequired = this.hasCustomName();
        }
    }

    @Inject(method={"checkDespawn()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;discard()V", shift=At.Shift.AFTER)})
    private void onDespawn(CallbackInfo ci) {
        if (((Boolean)AllConfigs.common().ENABLE_LET_ME_DESPAWN_OPTIMIZATION.get()).booleanValue() && this.getTags().contains("despawnTweaker.pickedItems")) {
            this.despawnTweaker$dropEquipmentOnDespawn();
        }
    }

    @Unique
    private void despawnTweaker$dropEquipmentOnDespawn() {
        if (!((Boolean)AllConfigs.common().ALLOW_EQUIPMENT_DROPS.get()).booleanValue()) {
            return;
        }
        for (EquipmentSlot equipmentSlot : EQUIPMENT_SLOTS) {
            ItemStack itemStack = this.getItemBySlot(equipmentSlot);
            boolean tagPresent = itemStack.has(DataComponentRegistry.get());
            if (itemStack.isEmpty() || tagPresent && ((ItemEnchantments)itemStack.get(DataComponents.ENCHANTMENTS)).toString().contains("vanishing_curse")) continue;
            if (tagPresent && ((Boolean)itemStack.get(DataComponentRegistry.get())).booleanValue()) {
                itemStack.remove(DataComponentRegistry.get());
            }
            this.spawnAtLocation(itemStack);
            this.setItemSlot(equipmentSlot, ItemStack.EMPTY);
        }
    }

    @Unique
    private void despawnTweaker$removeTagOnDeath() {
        for (EquipmentSlot equipmentSlot : EQUIPMENT_SLOTS) {
            ItemStack itemStack = this.getItemBySlot(equipmentSlot);
            boolean tagPresent = itemStack.has(DataComponentRegistry.get());
            if (!tagPresent || itemStack.isEmpty() || ((ItemEnchantments)itemStack.get(DataComponents.ENCHANTMENTS)).toString().contains("vanishing_curse") || !((Boolean)itemStack.get(DataComponentRegistry.get())).booleanValue()) continue;
            itemStack.remove(DataComponentRegistry.get());
        }
    }

    @Inject(method={"dropFromLootTable(Lnet/minecraft/world/damagesource/DamageSource;Z)V", "dropCustomDeathLoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;Z)V"}, at={@At(value="HEAD")})
    private void onDropFromLootTable(CallbackInfo ci) {
        if (this.getTags().contains("despawnTweaker.pickedItems")) {
            this.despawnTweaker$removeTagOnDeath();
        }
    }

    @Override
    @NotNull
    public Set<Structure> despawnTweaker$getSpawnStructures() {
        return this.despawnTweaker$spawnStructures == null ? Collections.emptySet() : this.despawnTweaker$spawnStructures;
    }

    @Override
    public void despawnTweaker$setSpawnStructures(Set<Structure> structureFeature) {
        this.despawnTweaker$spawnStructures = structureFeature;
    }
}

