/*
 * Decompiled with CFR 0.152.
 */
package toni.despawntweaks.foundation;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.MobDespawnEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import toni.despawntweaks.foundation.IDespawnTweaksMob;
import toni.despawntweaks.foundation.config.AllConfigs;

public class ForgeSpawnEvents {
    private static final Supplier<Set<String>> STRUCTURE_MODS = Suppliers.memoize(() -> new HashSet((Collection)AllConfigs.common().STRUCTURES_MODS.get()));
    private static final Supplier<Set<String>> STRUCTURES = Suppliers.memoize(() -> new HashSet((Collection)AllConfigs.common().STRUCTURES.get()));
    private static final Supplier<Registry<Structure>> STRUCTURES_REGISTRY = Suppliers.memoize(() -> ServerLifecycleHooks.getCurrentServer().registryAccess().registryOrThrow(Registries.STRUCTURE));

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSpawn(FinalizeSpawnEvent event) {
        if (event.isSpawnCancelled()) {
            return;
        }
        if (((Boolean)AllConfigs.common().ALLOW_MOBS_SPAWNED_BY_SPAWNERS_TO_DESPAWN.get()).booleanValue()) {
            return;
        }
        Mob entity = event.getEntity();
        if (!event.getSpawnType().equals((Object)MobSpawnType.SPAWNER)) {
            return;
        }
        if (entity.level().isClientSide) {
            return;
        }
        ((IDespawnTweaksMob)entity).despawnTweaker$setSpawnStructures(entity.level().getChunkAt(entity.blockPosition()).getAllReferences().keySet());
        entity.addTag("despawntweaks.shouldNotDespawn");
    }

    @SubscribeEvent
    public static void onDespawn(MobDespawnEvent event) {
        MobDespawnEvent.Result deny = MobDespawnEvent.Result.DENY;
        if (event.getResult().equals((Object)deny)) {
            return;
        }
        Mob entity = event.getEntity();
        if (entity.level().isClientSide) {
            return;
        }
        if (!entity.getTags().contains("despawntweaks.shouldNotDespawn")) {
            return;
        }
        ChunkAccess levelChunk = entity.level().getChunk(entity.blockPosition().getX() >> 4, entity.blockPosition().getZ() >> 4, ChunkStatus.FULL, false);
        if (levelChunk == null) {
            return;
        }
        if (((Set)STRUCTURE_MODS.get()).isEmpty() && ((Set)STRUCTURES.get()).isEmpty()) {
            event.setResult(deny);
        } else {
            for (Structure structure : ((IDespawnTweaksMob)entity).despawnTweaker$getSpawnStructures()) {
                boolean canDeny;
                ResourceLocation registryName = ((Registry)STRUCTURES_REGISTRY.get()).getKey((Object)structure);
                if (registryName == null) continue;
                boolean bl = canDeny = ((Set)STRUCTURE_MODS.get()).contains(registryName.getNamespace()) || ((Set)STRUCTURES.get()).contains(registryName.toString());
                if (!canDeny) continue;
                event.setResult(deny);
                break;
            }
        }
    }
}

