/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity.ai.goal;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SitAndLookGoal
extends Goal {
    private static final int MIN_REST_TIME = 60;
    private static final int MAX_REST_TIME = 200;
    private static final double LOOK_RANGE = 8.0;
    private final AbstractGoblinEntity goblin;
    private final TargetingConditions conditions;
    private int timeout;
    @Nullable
    protected Entity focusAt;

    public SitAndLookGoal(AbstractGoblinEntity goblin) {
        this.goblin = goblin;
        this.conditions = TargetingConditions.forNonCombat().range(8.0);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.goblin.isSitting()) {
            return false;
        }
        return this.goblin.getRandom().nextInt(200) == 0;
    }

    public boolean canContinueToUse() {
        return !this.goblin.isStunned() && !this.goblin.isPanicking() && this.goblin.isSitting() && this.timeout > 0;
    }

    public void start() {
        this.goblin.setSitting(true);
        this.timeout = this.goblin.getRandom().nextIntBetweenInclusive(60, 200);
    }

    public void stop() {
        this.goblin.setSitting(false);
        this.goblin.setCurious(false);
        this.focusAt = null;
    }

    public void tick() {
        --this.timeout;
        if (this.focusAt != null) {
            if (!this.goblin.isCurious() && this.goblin.getRandom().nextFloat() < 0.05f) {
                this.goblin.setCurious(true);
            }
        } else if (this.goblin.isCurious()) {
            this.goblin.setCurious(false);
        }
        this.updateFocusTarget();
        if (this.focusAt != null) {
            this.goblin.getLookControl().setLookAt(this.focusAt.getX(), this.focusAt.getEyeY(), this.focusAt.getZ());
        }
    }

    private void updateFocusTarget() {
        if (this.focusAt == null) {
            if (this.goblin.getRandom().nextFloat() >= 0.05f) {
                return;
            }
            Level level = this.goblin.level();
            this.focusAt = level.getNearestEntity(level.getEntitiesOfClass(LivingEntity.class, this.goblin.getBoundingBox().inflate(8.0, 3.0, 8.0), v -> true), this.conditions, (LivingEntity)this.goblin, this.goblin.getX(), this.goblin.getEyeY(), this.goblin.getZ());
        }
        if (this.focusAt != null && (!this.focusAt.isAlive() || this.focusAt.distanceToSqr((Entity)this.goblin) > 64.0)) {
            this.focusAt = null;
        }
    }
}

